/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.util.activator.impl;

import static com.openexchange.util.custom.base.NullUtil.className;
import static com.openexchange.util.custom.base.NullUtil.logger;

import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import com.openexchange.osgi.ExceptionUtils;

/**
 * {@link DependentServiceRegistration}
 *
 * @author <a href="mailto:pascal.bleser@open-xchange.com">Pascal Bleser</a>
 * @since v7.8.2
 */
public final class DependentServiceRegistration implements Registration {

    private static final Logger LOG = logger(DependentServiceRegistration.class);

    private final ServiceTracker<?, ?> serviceTracker;
    private final String name;
    public DependentServiceRegistration(final ServiceTracker<?, ?> serviceTracker, final String name) {
        this.serviceTracker = serviceTracker;
        this.name = name;
    }
    @Override
    public void close() {
        try {
            RegistrationTools.close(serviceTracker.getService(), name);
        } finally {
            try {
                serviceTracker.close();
            } catch (final Throwable t) {
                ExceptionUtils.handleThrowable(t);
                LOG.error(String.format("caught exception while closing tracker %s: %s: %s", name, className(t), t.getMessage()), t);
            }
        }
    }
}
