/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.util.activator.impl;



import com.openexchange.annotation.Nullable;
import com.openexchange.util.activator.DependencyProvider;
import com.openexchange.util.activator.ServiceDependencyResolver;


/**
 * {@link DependencyProviderServiceWithDependencies}
 *
 * @author <a href="mailto:pascal.bleser@open-xchange.com">Pascal Bleser</a>
 * @since v1.0.0
 */
public class DependencyProviderServiceWithDependencies<S, T extends S> extends ServiceWithDependenciesTemplate<S, T> {

    private final T serviceInstance;
    
    @SuppressWarnings("unchecked")
    public DependencyProviderServiceWithDependencies(final T serviceInstance,
        final @Nullable Class<S> optServiceClass) {
        super(
            (Class<T>) serviceInstance.getClass(),
            optServiceClass,
            ((DependencyProvider) serviceInstance).dependsOn().mandatoryServiceDependencies(),
            ((DependencyProvider) serviceInstance).dependsOn().optionalServiceDependencies(),
            ((DependencyProvider) serviceInstance).dependsOn().serviceSetClasses(),
            ((DependencyProvider) serviceInstance).dependsOn().serviceListingClasses()
        );
        this.serviceInstance = serviceInstance;
    }

    @Override
    public T createInstance(ServiceDependencyResolver resolver) {
        ((DependencyProvider) serviceInstance).onDependenciesAvailable(resolver);
        return serviceInstance;
    }

}
