/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.util.activator.impl;

import static com.openexchange.util.custom.base.NullUtil.logger;

import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;


/**
 * {@link AdditionalServiceRegistration}
 *
 * @author <a href="mailto:pascal.bleser@open-xchange.com">Pascal Bleser</a>
 * @since v7.8.2
 */
public class AdditionalServiceRegistration implements Registration {

    private static final Logger LOG = logger(AdditionalServiceRegistration.class);
    private final ServiceRegistration<?> serviceRegistration;

    public AdditionalServiceRegistration(ServiceRegistration<?> serviceRegistration) {
        this.serviceRegistration = serviceRegistration;
    }

    @Override
    public void close() {
        try {
            serviceRegistration.unregister();
        } catch (final Exception e) {
            // TODO add a name and more information for diagnosis
            LOG.error("exception caught while unregistering service registration", e);
        }
    }

}
