package com.openexchange.util.custom.base;


import com.google.common.collect.ImmutableSet;

/**
 * Successful result of a {@linkplain StringInterpolator#interpolate(CharSequence, String, String) string interpolation}.
 */
public final class StringInterpolation {
    
    private final String result;
    private final ImmutableSet<String> interpolated;
    
    public StringInterpolation(String result, ImmutableSet<String> interpolated) {
        this.result = result;
        this.interpolated = interpolated;
    }

    /**
     * Returns the value that resulted from the String interpolation.
     * @return the value that resulted from the String interpolation
     */
    public String result() {
        return result;
    }
    
    /**
     * Returns the placeholders that have been resolved.
     * @return the placeholders that have been resolved
     */
    public ImmutableSet<String> interpolated() {
        return interpolated;
    }
}