/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.util.activator.impl;

import static com.openexchange.util.custom.base.NullUtil.immutableSetCopyOf;
import java.lang.reflect.Constructor;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import javax.servlet.http.HttpServlet;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import com.google.common.collect.ImmutableSet;
import com.openexchange.annotation.Nullable;
import com.openexchange.config.ConfigurationService;
import com.openexchange.util.activator.ServiceRegistrationHandler;

/**
 * {@link ServletClassServiceWithDependencies}
 *
 * @author <a href="mailto:pascal.bleser@open-xchange.com">Pascal Bleser</a>
 * @since v1.0.2
 * @param <S>
 * @param <T>
 */
@Immutable
public final class ServletClassServiceWithDependencies<T extends HttpServlet> extends ClassServiceWithDependenciesTemplate<HttpServlet, T> {
    
    public static final <Y extends HttpServlet> ServiceWithDependencies<Y> find(final Class<Y> serviceInstanceClass, final String path) {
        final DependencyScan<HttpServlet, Y> scan = scan(serviceInstanceClass);
        
        final Set<MandatoryServiceDependency<?>> mandatoryDeps = new HashSet<>();
        mandatoryDeps.add(new MandatoryServiceDependency<>(HttpService.class));
        if (path.contains("${")) {
            mandatoryDeps.add(new MandatoryServiceDependency<>(ConfigurationService.class));
        }
        mandatoryDeps.addAll(scan.mandatoryDependencies);
        
        return new ServletClassServiceWithDependencies<Y>(path,
            scan.constructor,
            serviceInstanceClass,
            immutableSetCopyOf(mandatoryDeps),
            scan.optionalDependencies,
            scan.serviceSets,
            scan.serviceListings
        );    
    }
    
    private final String path;
    
    public ServletClassServiceWithDependencies(final String path,
        final Constructor<T> constructor,
        final Class<T> serviceInstanceClass,
        final ImmutableSet<MandatoryServiceDependency<?>> mandatoryDependencies,
        final ImmutableSet<OptionalServiceDependency<?>> optionalDependencies,
        final ImmutableSet<Class<?>> serviceSets,
        final ImmutableSet<Class<?>> serviceListings) {
        super(constructor, serviceInstanceClass, HttpServlet.class, mandatoryDependencies, optionalDependencies, serviceSets, serviceListings);
        this.path = path;
    }

    @Override
    protected ServiceTrackerCustomizer<HttpServlet, T> createRegisterer(final BundleContext bundleContext,
        final ActivatorRegistry registry,
        final ImmutableSet<Class<?>> serviceClasses,
        final Dictionary<String, ?> properties,
        final @Nullable ServiceRegistrationHandler<T> serviceRegistrationHandler) {
        return new ServletServiceRegisterer<T>(path,
            bundleContext,
            serviceClasses,
            serviceInstanceClass,
            properties,
            mandatoryDependencies,
            optionalDependencies,
            RegistrationTools.serviceSets(bundleContext, registry, serviceSets),
            RegistrationTools.serviceListings(bundleContext, registry, serviceListings),
            RegistrationTools.collectPropertiesOfInterest(mandatoryDependencies, optionalDependencies),
            constructor,
            serviceRegistrationHandler
        );        
    }
    
}