/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.data;

import com.openexchange.osgi.data.AbstractDependency;
import com.openexchange.osgi.data.AbstractModule;
import com.openexchange.osgi.data.BinDirModule;
import com.openexchange.osgi.data.BundleImport;
import com.openexchange.osgi.data.JDK;
import com.openexchange.osgi.data.JarModule;
import com.openexchange.osgi.data.ModuleDependencies;
import com.openexchange.osgi.data.OSGIManifest;
import com.openexchange.osgi.data.RequiredBundle;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\rJ\u001e\u0010\u0017\u001a\u00020\u000f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\fJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00072\u0006\u0010 \u001a\u00020\fH\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\f2\u0006\u0010 \u001a\u00020\fH\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002RN\u0010\u0005\u001aB\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t \b* \u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/openexchange/osgi/data/ModuleDatabase;", "", "logger", "Lorg/gradle/api/logging/Logger;", "(Lorg/gradle/api/logging/Logger;)V", "binaries", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "Lcom/openexchange/osgi/data/AbstractModule;", "kotlin.jvm.PlatformType", "", "modules", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/openexchange/osgi/data/OSGIManifest;", "addBinaryModules", "", "files", "", "Ljava/io/File;", "([Ljava/io/File;)V", "addModule", "moduleName", "manifest", "duplicateModule", "", "module", "getModuleDependencies", "Lcom/openexchange/osgi/data/ModuleDependencies;", "searchBinariesForBundle", "reqBundle", "Lcom/openexchange/osgi/data/RequiredBundle;", "searchBinariesForExport", "export", "searchModulesForExport", "searchProjectsForBundle", "osgi"})
public final class ModuleDatabase {
    private final ConcurrentHashMap<String, OSGIManifest> modules;
    private final ConcurrentHashMap.KeySetView<AbstractModule, Boolean> binaries;
    private final Logger logger;

    public final void addModule(@NotNull String moduleName, @NotNull OSGIManifest manifest) {
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        Intrinsics.checkParameterIsNotNull((Object)manifest, (String)"manifest");
        Map map2 = this.modules;
        OSGIManifest oSGIManifest = manifest;
        map2.put(moduleName, oSGIManifest);
        this.logger.info("Osgi-Plugin: Added: " + moduleName + " as bundle to the Module-Database");
    }

    public final void addBinaryModules(File ... files) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)files, (String)"files");
        for (File file : files) {
            AbstractModule abstractModule;
            if (file.isFile()) {
                abstractModule = new JarModule(file);
            } else if (file.isDirectory()) {
                abstractModule = new BinDirModule(file);
            } else {
                throw (Throwable)new IOException("Don't know how to handle " + file.getAbsolutePath());
            }
            AbstractModule module = abstractModule;
            if (this.binaries.add(module)) continue;
            ConcurrentHashMap.KeySetView<AbstractModule, Boolean> keySetView = this.binaries;
            Intrinsics.checkExpressionValueIsNotNull(keySetView, (String)"binaries");
            this.duplicateModule((Set<? extends AbstractModule>)keySetView, module);
        }
        this.logger.info("OSGi-Plugin: Added binary modules to the Module-Database");
    }

    private final void duplicateModule(Set<? extends AbstractModule> modules, AbstractModule module) throws IOException {
        String string;
        AbstractModule other = null;
        for (AbstractModule abstractModule : modules) {
            if (!Intrinsics.areEqual((Object)abstractModule, (Object)module)) continue;
            other = abstractModule;
            break;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Trying to add duplicate module ");
        File file = module.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"module.getFile()");
        StringBuilder stringBuilder2 = stringBuilder.append(file.getAbsolutePath()).append(". Other module is ");
        if (other != null) {
            File file2 = other.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"other.getFile()");
            string = file2.getAbsolutePath();
        } else {
            string = "unknown";
        }
        throw (Throwable)new IOException(stringBuilder2.append(string).append(".").toString());
    }

    @NotNull
    public final ModuleDependencies getModuleDependencies(@NotNull String moduleName) throws GradleException {
        Object it;
        Object object;
        OSGIManifest myManifest;
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        OSGIManifest oSGIManifest = myManifest = this.modules.get(moduleName);
        if (oSGIManifest == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)oSGIManifest, (String)"myManifest!!");
        Set<BundleImport> myImports = oSGIManifest.getImports();
        ModuleDependencies myDependencies = new ModuleDependencies();
        Set<RequiredBundle> requiredBundles = myManifest.getRequiredBundles();
        Set<RequiredBundle> set = myManifest.getFragmentHost();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"myManifest.fragmentHost");
        requiredBundles.addAll((Collection<RequiredBundle>)set);
        Iterator<AbstractDependency> iterator = requiredBundles.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            boolean bl2;
            RequiredBundle reqBundle;
            RequiredBundle requiredBundle = reqBundle = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)requiredBundle, (String)"reqBundle");
            if (Intrinsics.areEqual((Object)requiredBundle.getPackageName(), (Object)"system.bundle")) continue;
            object = this.searchProjectsForBundle(reqBundle);
            it = object;
            if (it == null) {
                bl2 = false;
            } else {
                myDependencies.addProject((String)it);
                bl2 = true;
            }
            if (bl2) continue;
            object = this.searchBinariesForBundle(reqBundle);
            it = object;
            if (it == null) {
                bl = false;
            } else {
                File file = ((AbstractModule)it).getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it.getFile()");
                myDependencies.addBinary(file);
                bl = true;
            }
            if (bl || reqBundle.isOptional()) continue;
            throw (Throwable)new GradleException("OSGi-Plugin: Could not find required Bundle: " + reqBundle.getPackageName() + " for: " + moduleName + " in Module-Database");
        }
        for (BundleImport myImport : myImports) {
            boolean bl;
            boolean bl3;
            Set<String> set2 = myManifest.getExports();
            BundleImport bundleImport = myImport;
            Intrinsics.checkExpressionValueIsNotNull((Object)bundleImport, (String)"myImport");
            if (set2.contains(bundleImport.getPackageName())) {
                this.logger.warn(moduleName + ": is importing and exporting the same Package!");
                continue;
            }
            if (JDK.exports(myImport.getPackageName())) continue;
            String string = myImport.getPackageName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"myImport.packageName");
            object = this.searchModulesForExport(string);
            it = object;
            if (it == null) {
                bl3 = false;
            } else {
                myDependencies.addProject((String)it);
                bl3 = true;
            }
            if (bl3) continue;
            String string2 = myImport.getPackageName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"myImport.packageName");
            object = this.searchBinariesForExport(string2);
            it = object;
            if (it == null) {
                bl = false;
            } else {
                File file = ((AbstractModule)it).getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it.getFile()");
                myDependencies.addBinary(file);
                bl = true;
            }
            if (bl || myImport.isOptional()) continue;
            throw (Throwable)new GradleException("OSGi-Plugin: Couldn't find required Export: " + myImport.getPackageName() + " for: " + moduleName + " in Module-Database ");
        }
        return myDependencies;
    }

    private final String searchProjectsForBundle(RequiredBundle reqBundle) {
        if (this.modules.containsKey(reqBundle.getPackageName())) {
            return reqBundle.getPackageName();
        }
        return null;
    }

    private final AbstractModule searchBinariesForBundle(RequiredBundle reqBundle) {
        Iterator<AbstractModule> iterator = this.binaries.iterator();
        while (iterator.hasNext()) {
            AbstractModule binary;
            AbstractModule abstractModule = binary = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)abstractModule, (String)"binary");
            if (!Intrinsics.areEqual((Object)abstractModule.getSymbolicName(), (Object)reqBundle.getPackageName())) continue;
            return binary;
        }
        return null;
    }

    private final AbstractModule searchBinariesForExport(String export) {
        Iterator<AbstractModule> iterator = this.binaries.iterator();
        while (iterator.hasNext()) {
            AbstractModule binary;
            AbstractModule abstractModule = binary = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)abstractModule, (String)"binary");
            for (String currentExport : abstractModule.getExportedPackages()) {
                if (!Intrinsics.areEqual((Object)export, (Object)currentExport)) continue;
                return binary;
            }
        }
        return null;
    }

    private final String searchModulesForExport(String export) {
        Map map2 = this.modules;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            String currentModule = (String)entry2.getKey();
            entry2 = entry;
            OSGIManifest value = (OSGIManifest)entry2.getValue();
            for (String currentExport : value.getExports()) {
                if (!Intrinsics.areEqual((Object)export, (Object)currentExport)) continue;
                return currentModule;
            }
        }
        return null;
    }

    public ModuleDatabase(@NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.logger = logger;
        this.modules = new ConcurrentHashMap();
        this.binaries = ConcurrentHashMap.newKeySet();
    }
}

