/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.util.activator;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Mark the dependency on an OSGi service or a service constructor.
 * <p>
 * Use this annotation on a constructor when a service has more than
 * one constructors, to mark the one that ought to be invoked by
 * the ActivatorTemplate.
 * <p>
 * Alternatively, use this annotation on service constructor parameters
 * to mark them as dependencies on other OSGi services.
 * Those will be registered as dependencies of this service using their
 * parameter type (hence always use the interface of a service as
 * the parameter type) and then injected into the constructor parameter
 * when all the dependencies have been resolved.
 * <p>
 * Additionally, when used as a constructor parameter annotation, one
 * may specify an id of a service to be injected into the parameter.
 * Only services that have been registered with a property "id" matching
 * that value will be injected into the constructor parameter.
 * <p>
 * Note that as of version 1.0.1, unless there is the need to specify
 * an id, there is no need to annotate service dependencies in
 * constructor parameters, they will be assumed to be.
 *
 * @author <a href="mailto:pascal.bleser@open-xchange.com">Pascal Bleser</a>
 * @since v1.0.0
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.PARAMETER, ElementType.CONSTRUCTOR})
public @interface Service {
    
    /**
     * The value of the "id" service property that will need to be
     * matched for this dependency.
     * <p>
     * This attribute is only supported when used on constructor parameter
     * annotations, as it makes no sense when annotating constructor methods.
     * <p>
     * A value of {@code ""} means that there is no id property to match.
     * <p>
     * A value of {@code "*"} means that any service matching the type of
     * the annotated parameter will be used to fulfill the dependency,
     * regardless of whether it has an id property or not and, if so,
     * regardless of its value.
     * 
     * @return
     */
    String id() default "";
}
