/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.json.response;

import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.usm.api.exceptions.USMJSONException;
import com.openexchange.usm.json.USMJSONAPIException;

/**
 * The JSONObject to be returned in the Response of any USM-JSON-Command.
 * @author ldo
 *
 */
public class ResponseObject extends JSONObject {

	public static final String DATA = "data";
	public static final String STATUS = "status";
	public static final String ERROR_CODE = "errorCode";
	public static final String ERROR_MESSAGE = "errorMessage";
	public static final String ERROR_DETAILS = "errorDetails";
	public static final String ERROR_STATUS = "errorStatus";
	public static final String OX_ERROR = "oxError";

	private final ResponseStatusCode _status;
	private final Object _data;
	private final int _errorCode;
	private final String _errorMessage;
	private final JSONObject _errorDetails;
	private final JSONObject _oxError;
	private final USMJSONException _exception;

	public ResponseObject(ResponseStatusCode status) {
		this(status, null, 0, null, null, null, null);
	}

	public ResponseObject(ResponseStatusCode status, Object data) {
		this(status, data, 0, null, null, null, null);
	}

	public ResponseObject(ResponseStatusCode status, int errorCode, String errorMessage, JSONObject errorDetails,
			JSONObject oxError) {
		this(status, null, errorCode, errorMessage, errorDetails, oxError, null);
	}

	public ResponseObject(ResponseStatusCode status, USMJSONException error) {
		this(status, null, error.getErrorCode(), error.getErrorMessage(), error.getErrorDetailsForJSONResponse(), error
				.getOxErrorForJSONResponse(), error);
	}

	public ResponseObject(ResponseStatusCode status, Object data, USMJSONException error) {
		this(status, data, error.getErrorCode(), error.getErrorMessage(), error.getErrorDetailsForJSONResponse(), error
				.getOxErrorForJSONResponse(), error);
	}

	public ResponseObject(USMJSONAPIException error) {
		this(error.getResponseStatusCode(), null, error.getErrorCode(), error.getErrorMessage(), error
				.getErrorDetailsForJSONResponse(), error.getOxErrorForJSONResponse(), error);
	}

	public ResponseObject(ResponseStatusCode status, Object data, int errorCode, String errorMessage,
			JSONObject errorDetails, JSONObject oxError, USMJSONException cause) {
		super();
		_status = status;
		_data = data;
		_errorCode = errorCode;
		_errorMessage = errorMessage;
		_errorDetails = errorDetails;
		_oxError = oxError;
		_exception = cause;
		try {
			if (_status != null)
				this.put(STATUS, _status.getStatusCode());
			if (_data != null)
				this.put(DATA, _data);
			if (_errorCode != 0)
				this.put(ERROR_CODE, _errorCode);
			if (_errorMessage != null)
				this.put(ERROR_MESSAGE, _errorMessage);
			if (_errorDetails != null)
				this.put(ERROR_DETAILS, _errorDetails);
			if (_oxError != null)
				this.put(OX_ERROR, _oxError);
		} catch (JSONException ignored) {
			// Ignored since it can never happen with our fixed keys
		}
	}

	public ResponseStatusCode getStatusCode() {
		return _status;
	}

	public Object getData() {
		return _data;
	}

	public int getErrorCode() {
		return _errorCode;
	}

	public String getErrorMessage() {
		return _errorMessage;
	}

	public JSONObject getErrorDetails() {
		return _errorDetails;
	}

	public JSONObject getOxError() {
		return _oxError;
	}

	public USMJSONException getCause() {
		return _exception;
	}
}
