/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.connector.commands;

import static com.openexchange.usm.connector.commands.CommandConstants.SESSIONID;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.usm.api.contenttypes.common.ContentTypeField;
import com.openexchange.usm.api.contenttypes.common.DefaultContentTypes;
import com.openexchange.usm.api.contenttypes.contact.ContactContentType;
import com.openexchange.usm.api.datatypes.DataType;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.json.ConnectorBundleErrorCodes;
import com.openexchange.usm.json.USMJSONAPIException;
import com.openexchange.usm.json.USMJSONServlet;
import com.openexchange.usm.json.response.ResponseObject;
import com.openexchange.usm.json.response.ResponseStatusCode;

/**
 * Handler for the ResolveRecipients USM-JSON-Command.
 * @author ldo
 *
 */
public class ResolveRecipientsHandler extends NormalCommandHandler {

	private static final String NAMES = "names";
	private static final String PROPERTIES = "properties";

	private static final String[] REQUIRED_PARAMETERS = { SESSIONID, PROPERTIES, NAMES };
	private static final String[] OPTIONAL_PARAMETERS = {};

    public ResolveRecipientsHandler(USMJSONServlet servlet, HttpServletRequest request) throws USMJSONAPIException {
        super(servlet, request);
    }

	@Override
	public ResponseObject handleRequest() throws USMJSONAPIException {
		JSONArray properties = getJSONArray(_parameters, PROPERTIES);
		JSONArray names = getJSONArray(_parameters, NAMES);
		BitSet requestedFields = checkProperties(properties);
		JSONArray data = createResponseData(properties, names, requestedFields);
		return new ResponseObject(ResponseStatusCode.SUCCESS, data);
	}

	private JSONArray createResponseData(JSONArray properties, JSONArray names, BitSet requestedFields)
			throws USMJSONAPIException {
		JSONArray resultArray = new JSONArray();
		try {
			ContactContentType contentType = (ContactContentType) _servlet.getContentTypeManager().getContentType(
					DefaultContentTypes.CONTACTS_ID);
			List<String> toList = new ArrayList<String>();
			int length = names.length();
			for (int i = 0; i < length; i++) {
				toList.add(getString(names, i));
			}
			Map<String, DataObject[]> recipients = contentType.resolveRecipients(toList, _session, requestedFields);
			for (Map.Entry<String, DataObject[]> entry : recipients.entrySet()) {
				for (DataObject o : entry.getValue())
					resultArray.put(storeDataObjectFieldsInJSONObject(o, requestedFields));
			}
		} catch (USMException e) {
			throw USMJSONAPIException.createInternalError(
					ConnectorBundleErrorCodes.RESOLVE_RECIPIENTS_CAN_NOT_GET_CONTACTS, e);
		} catch (JSONException e) {
			throw USMJSONAPIException.createJSONError(
					ConnectorBundleErrorCodes.RESOLVE_RECIPIENTS_CAN_NOT_CREATE_RESPONCE, e);
		}
		return resultArray;
	}

	protected JSONObject storeDataObjectFieldsInJSONObject(DataObject o, BitSet requestedFields) throws JSONException,
			USMJSONAPIException {
		JSONObject newObject = new JSONObject();
		ContentTypeField[] fields = o.getContentType().getFields();
		for (int i = 0; i < fields.length; i++) {
			DataType<?> fieldType = fields[i].getFieldType();
			Object v = o.getFieldContent(i);
			if (requestedFields.get(i) && o.isFieldModified(i))
				fieldType.storeInJSONObject(o.getSession(), newObject, fields[i].getFieldName(), v);
		}
		return newObject;
	}

	private BitSet checkProperties(JSONArray properties) throws USMJSONAPIException {
		BitSet requestedFields = new BitSet();
		try {
			JSONArray availableContactProperties = null;
			try {
				JSONObject availableContentTypes = getAvailableContentTypes(_servlet.getContentTypeManager());
				availableContactProperties = availableContentTypes.getJSONArray(DefaultContentTypes.CONTACTS_ID);
			} catch (USMException e) {
				throw USMJSONAPIException.createInternalError(
						ConnectorBundleErrorCodes.RESOLVE_RECIPIENTS_RETRIEVE_AVAILABLE_FIELDS, e);
			}
			int length = properties.length();
			for (int i = 0; i < length; i++) {
				String property = properties.getString(i);
				boolean exist = false;
				int length2 = availableContactProperties.length();
				for (int j = 0; j < length2; j++) {
					if (availableContactProperties.getString(j).equals(property)) {
						exist = true;
						requestedFields.set(getContactFieldIndex(property));
					}
				}
				if (!exist)
					throw new USMJSONAPIException(ConnectorBundleErrorCodes.RESOLVE_RECIPIENTS_WRONG_PROPERTIES,
							ResponseStatusCode.WRONG_MISSING_PARAMETERS, "Unknown property " + property);
			}
		} catch (JSONException e) {
			throw USMJSONAPIException.createJSONError(
					ConnectorBundleErrorCodes.RESOLVE_RECIPIENTS_JSON_ERROR_PROPERTIES, e);
		}
		return requestedFields;
	}

	private int getContactFieldIndex(String name) {
		ContentTypeField[] fields = _servlet.getContentTypeManager().getContentType(DefaultContentTypes.CONTACTS_ID)
				.getFields();
		for (int i = 0; i < fields.length; i++) {
			if (fields[i].getFieldName().equals(name))
				return i;
		}
		return -1;
	}

	@Override
	protected String[] getOptionalParameters() {
		return OPTIONAL_PARAMETERS;
	}

	@Override
	protected String[] getRequiredParameters() {
		return REQUIRED_PARAMETERS;
	}
}
