/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.usm.ox_json.impl;

import static com.openexchange.usm.util.OXJSONUtil.DATA_FIELD;
import static com.openexchange.usm.util.OXJSONUtil.ERROR_FIELD;
import static com.openexchange.usm.util.OXJSONUtil.isOXError;

import java.io.IOException;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

import com.openexchange.usm.api.ox.json.JSONResult;
import com.openexchange.usm.api.ox.json.JSONResultType;
import com.openexchange.usm.util.OXJSONUtil;

public class OXJSONSupport {


    public static JSONResult parseResult(String content, JSONResultType expectedResultType) throws IOException {
        JSONTokener tokener = new JSONTokener(content);
        try {
            char c = tokener.nextClean();
            switch (c) {
            case '[':
            case '(':
                tokener.back();
                JSONArrayResult result = new JSONArrayResult(new JSONArray(tokener));
                if (tokener.nextClean() == 0) {
                    if (isValidResultType(expectedResultType, JSONResultType.JSONArray))
                        return result;
                    JSONObject errorDetails = new JSONObject();
                    try {
                        errorDetails.put(DATA_FIELD, result.getJSONArray());
                        errorDetails.put(ERROR_FIELD, "Invalid array response from server, expected " + expectedResultType);
                    } catch (JSONException ignored) {
                        //should not happen - object creation
                    }
                    return new JSONErrorResult(errorDetails);
                }
                break;
            case '{':
                tokener.back();
                JSONObject object = new JSONObject(tokener);
                if (tokener.nextClean() == 0)
                    return generateJSONResultForJSONObject(object, expectedResultType);
                break;
            default:
                break;
            }
        } catch (JSONException ignored) {
            //Should not happen - object creation
        }
        if (isValidResultType(expectedResultType, JSONResultType.String))
            return new JSONStringResult(content);
        JSONObject errorDetails = new JSONObject();
        try {
            errorDetails.put(DATA_FIELD, content);
            errorDetails.put(ERROR_FIELD, "Invalid string response from server, expected " + expectedResultType);
        } catch (JSONException ignored) {
          //Should not happen - object creation
        }
        return new JSONErrorResult(errorDetails);
    }

    /**
     * if JSONObject has a field 'error' and the category of this error is not "13" then return JSONErrorResult if a field 'data' is
     * available and is not empty then observe the content of this field; if starts with '[' or '(' return JSONArrayResult if starts with
     * '{' return JSONObjectResult
     * 
     * @param object
     * @return
     */
    public static JSONResult generateJSONResultForJSONObject(JSONObject object, JSONResultType expectedResultType) {
        if (isOXError(object))
            return new JSONErrorResult(object);
        if (isValidResultType(expectedResultType, JSONResultType.JSONObject))
            return new JSONObjectResult(object);
        JSONObject errorDetails = new JSONObject();
        try {
            errorDetails.put(DATA_FIELD, object);
            errorDetails.put(ERROR_FIELD, "Invalid object response from server, expected " + expectedResultType);
        } catch (JSONException ignored) {
            // can not happen
        }
        return new JSONErrorResult(errorDetails);
    }

   

    private static boolean isValidResultType(JSONResultType expected, JSONResultType actual) {
        return expected == null || expected == actual;
    }


    public static boolean shouldPerformNewLogin(JSONResult result) {
        return result.getResultType() == JSONResultType.Error &&  OXJSONUtil.isReloginErrorCode(result.getJSONObject());
    }
}
