/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.contenttypes.util;

public class USMContentTypesUtilErrorCodes {

	/**
	 * Client is requesting fields from server which are not supported. 
	 */
	public static final int NOT_SUPPORTED_FIELD = 0x400000;

	/**
	 * Clients is requesting fields from server which not exist. 
	 */
	public static final int INVALID_FIELDS_REQUESTED = 0x400001;

	/**
	 * Client is receiving objects with invalid content type.
	 */
	public static final int INVALID_CONTENT_TYPE_RECEIVED = 0x400002;

	/**
	 * Client is sending objects with invalid content type.
	 */
	public static final int INVALID_CONTENT_TYPE_TO_WRITE = 0x400003;

	//read/update object

	/**
	 * OX send invalid/unexpected JSON result to the client.
	 */
	public static final int OX_RESULT_ERROR_NUMBER1 = 0x400010;
	public static final int OX_RESULT_ERROR_NUMBER2 = 0x400011;
	public static final int OX_RESULT_ERROR_NUMBER3 = 0x400012;
	public static final int OX_RESULT_ERROR_NUMBER4 = 0x400013;
	public static final int OX_RESULT_ERROR_NUMBER5 = 0x400014;
	public static final int OX_RESULT_ERROR_NUMBER6 = 0x400015;
	public static final int OX_RESULT_ERROR_NUMBER7 = 0x400016;
	public static final int OX_RESULT_ERROR_NUMBER8 = 0x400017;
	public static final int OX_RESULT_ERROR_NUMBER9 = 0x400018;
	public static final int OX_RESULT_ERROR_NUMBER10 = 0x400019;
	public static final int OX_RESULT_ERROR_NUMBER11 = 0x40001A;
	public static final int OX_RESULT_ERROR_NUMBER12 = 0x40001B;
	public static final int OX_RESULT_ERROR_NUMBER13 = 0x40001C;
	public static final int OX_RESULT_ERROR_NUMBER14 = 0x40001D;
	public static final int OX_RESULT_ERROR_NUMBER15 = 0x40001E;
	public static final int OX_RESULT_ERROR_NUMBER16 = 0x40001F;

	/**
	 * Data array is not present where expected in a JSON Result received from the OX server. 
	 */
	public static final int DATA_NOT_PRESENT_NUMBER1 = 0x400020;
	public static final int DATA_NOT_PRESENT_NUMBER2 = 0x400021;
	public static final int DATA_NOT_PRESENT_NUMBER3 = 0x400022;
	public static final int DATA_NOT_PRESENT_NUMBER4 = 0x400023;
	public static final int DATA_NOT_PRESENT_NUMBER5 = 0x400024;
	public static final int DATA_NOT_PRESENT_NUMBER6 = 0x400025;
	public static final int DATA_INVALID = 0x400026;
	public static final int DATA_NOT_PRESENT_NUMBER7 = 0x400027;
	public static final int DATA_NOT_PRESENT_NUMBER8 = 0x400028;
	public static final int DATA_NOT_PRESENT_NUMBER9 = 0x400029;

	/**
	 * OX server sent invalid timestamp in the JSON result.
	 */
	public static final int INVALID_TIMESTAMP_NUMBER1 = 0x400030;
	public static final int INVALID_TIMESTAMP_NUMBER2 = 0x400031;
	public static final int INVALID_TIMESTAMP_NUMBER3 = 0x400032;

	/**
	 * OX server did not sent ID for a new object.
	 */
	public static final int ID_NOT_PRESENT_NUMBER1 = 0x400040;
	public static final int ID_NOT_PRESENT_NUMBER2 = 0x400041;
	public static final int ID_NOT_PRESENT_NUMBER3 = 0x400042;
	public static final int ID_NOT_PRESENT_NUMBER4 = 0x400043;
	public static final int ID_NOT_PRESENT_NUMBER5 = 0x400044;
	public static final int ID_NOT_PRESENT_NUMBER6 = 0x400045;

	/**
	 * Error when reading the data from the JSON Result received form OX.
	 */
	public static final int ERROR_READING_DATA_NUMBER1 = 0x400050;
	public static final int ERROR_READING_DATA_NUMBER2 = 0x400051;
	public static final int ERROR_READING_DATA_NUMBER3 = 0x400052;
	public static final int ERROR_READING_DATA_NUMBER4 = 0x400053;
	public static final int ERROR_READING_DATA_NUMBER5 = 0x400054;
	public static final int ERROR_READING_DATA_NUMBER6 = 0x400055;
	public static final int ERROR_READING_DATA_NUMBER7 = 0x400056;

	/**
	 * Error when writing the data from the JSON Result received form OX into an USM object
	 * or when writing data to a JSON object. 
	 */
	public static final int ERROR_WRITING_DATA_NUMBER1 = 0x400060;
	public static final int ERROR_WRITING_DATA_NUMBER2 = 0x400061;
	public static final int ERROR_WRITING_DATA_NUMBER3 = 0x400062;
	public static final int ERROR_WRITING_DATA_NUMBER4 = 0x400063;
	public static final int ERROR_WRITING_DATA_NUMBER5 = 0x400064;
	public static final int ERROR_WRITING_DATA_NUMBER6 = 0x400065;
	public static final int ERROR_WRITING_DATA_NUMBER7 = 0x400066;

	//delete object

	/**
	 * Error when deleting object from server.
	 */
	public static final int DELETE_ERROR = 0x400070;

	//confirm task or appointment
	/**
	 * Error when confirming task or appointment. 
	 */
	public static final int CONFIRM_ERROR_NUMBER1 = 0x400080;
	public static final int CONFIRM_ERROR_NUMBER2 = 0x400081;
	public static final int CONFIRM_ERROR_NUMBER3 = 0x400082;

	public static final int CONFIRM_ERROR_NUMBER4 = 0x400083;
	public static final int CONFIRM_ERROR_NUMBER5 = 0x400084;
	public static final int CONFIRM_ERROR_NUMBER6 = 0x400085;

	public static final int DESERIALIZATION_FAILED_INVALID_FIELD_CONTENT = 0x400100;

	public static final int FOLDER_NOT_FOUND = 0x400101;

	public static final int IMAP_DOWN = 0x400102;

    public static final int INVALID_DATA_ON_READING_ALL_IDS = 0x400200;
}
