/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2013 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.usm.json.osgi;

import java.util.concurrent.ExecutorService;
import javax.servlet.ServletException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.tree.modules.interfaces.USM_JSON;
import com.openexchange.groupware.settings.tree.modules.interfaces.USM_JSONActive;
import com.openexchange.usm.api.configuration.ConfigurationManager;
import com.openexchange.usm.api.configuration.ConfigurationProperties;
import com.openexchange.usm.api.contenttypes.common.ContentTypeManager;
import com.openexchange.usm.api.exceptions.USMInvalidConfigurationException;
import com.openexchange.usm.api.exceptions.USMStartupException;
import com.openexchange.usm.api.session.SessionManager;
import com.openexchange.usm.json.ConnectorBundleErrorCodes;
import com.openexchange.usm.json.USMJSONServlet;
import com.openexchange.usm.json.USMJSONVersion;
import com.openexchange.usm.util.AbstractUSMActivator;

/**
 * {@link USMJSONServletActivator}
 *
 * @author <a href="mailto:ioannis.chouklis@open-xchange.com">Ioannis Chouklis</a>
 */
public class USMJSONServletActivator extends AbstractUSMActivator {
    
    private String servletAlias;

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.util.AbstractUSMActivator#getNeededServices()
     */
    @Override
    protected Class<?>[] getNeededServices() {
        return new Class<?>[]{HttpService.class, 
                              SessionManager.class, 
                              ContentTypeManager.class, 
                              ConfigurationManager.class};
    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.util.AbstractUSMActivator#register(org.osgi.framework.BundleContext)
     */
    @Override
    protected void register() {
        HttpService httpService = (HttpService) context.getService(presentServices.get(HttpService.class));
        SessionManager sessionManager = (SessionManager) context.getService(presentServices.get(SessionManager.class));
        ContentTypeManager ctManager = (ContentTypeManager) context.getService(presentServices.get(ContentTypeManager.class));
        ConfigurationManager cfManager = (ConfigurationManager) context.getService(presentServices.get(ConfigurationManager.class));
        
        try {
            servletAlias = cfManager.getProperty(ConfigurationProperties.JSON_SERVLET_ALIAS_PROPERTY, ConfigurationProperties.JSON_SERVLET_ALIAS_DEFAULT, true);
        } catch (USMInvalidConfigurationException e) {
            throw new USMStartupException(ConnectorBundleErrorCodes.INVALID_ALIAS_FOR_SERVLET, e.getMessage(), e);
        }
        
        USMJSONServlet servlet = new USMJSONServlet(sessionManager, ctManager, cfManager);
        
        try {
            httpService.registerServlet(servletAlias, servlet, null, httpService.createDefaultHttpContext());
            LOG.info("Connector servlet registered under alias " + servletAlias);
            LOG.info("Open-Xchange USM/JSON Version " + USMJSONVersion.VERSION + " (Build " + USMJSONVersion.BUILD_NUMBER + ") successfully started");
        } catch (ServletException e) {
            throw new USMStartupException(ConnectorBundleErrorCodes.SERVLET_REGISTRATION_FAILED, "Servlet registration failed", e);
        } catch (NamespaceException e) {
            throw new USMStartupException(ConnectorBundleErrorCodes.SERVLET_ALIAS_IN_USE, "Servlet alias already in use:" + servletAlias, e);
        }
        
        registerService(USMJSONServlet.class, servlet);
        LOG.info("USM-JSON Servlet registered.");
        
        USM_JSON usmJSON = new USM_JSON();
        context.registerService(PreferencesItemService.class, usmJSON, null);
        LOG.info("USM_JSON Preferences Item Service registered");
        
        USM_JSONActive usmJSONActive = new USM_JSONActive();
        context.registerService(PreferencesItemService.class, usmJSONActive, null);
        LOG.info("USM_JSON active Preferences Item Service registered");
        
        //TODO provide tracking functionality via the AbstractUSMActivator
        ServiceTracker<ExecutorService, ExecutorService> tracker = new ServiceTracker<ExecutorService, ExecutorService>(context, ExecutorService.class, new ServiceTrackerCustomizer<ExecutorService, ExecutorService>() {
            @Override
            public ExecutorService addingService(ServiceReference<ExecutorService> reference) {
                Object o = context.getService(reference);
                if (o instanceof ExecutorService) {
                    USMJSONServlet.setExecutorService((ExecutorService) o);
                }
                return (ExecutorService) o;
            }

            @Override
            public void modifiedService(ServiceReference<ExecutorService> reference, ExecutorService service) {
                // nothing
            }

            @Override
            public void removedService(ServiceReference<ExecutorService> reference, ExecutorService service) {
                Object o = context.getService(reference);
                if (o instanceof ExecutorService) {
                    USMJSONServlet.setExecutorService(null);
                }
            }
        });
        tracker.open();
    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.util.AbstractUSMActivator#unregister(org.osgi.framework.BundleContext)
     */
    @Override
    protected void unregister() {
        HttpService httpService = (HttpService) getService(HttpService.class);
        if (servletAlias != null && httpService != null) {
            httpService.unregister(servletAlias);
            LOG.info("Connector servlet unregistered from alias " + servletAlias);
            servletAlias = null;
        } else {
            LOG.info("Connector servlet unregistered");
        }
        USMJSONServlet.setExecutorService(null);
        LOG.info("USM-JSON unregistered.");        
    }

}
