CREATE TABLE USMSession (cid INT4 UNSIGNED NOT NULL, id INT4 UNSIGNED NOT NULL, device VARCHAR(64) NOT NULL, protocol VARCHAR(32) NOT NULL, usmSessionId INT4 UNSIGNED NOT NULL, PRIMARY KEY (cid, usmSessionId), UNIQUE (cid, id, device, protocol)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE USMSessionFields (cid INT4 UNSIGNED NOT NULL, usmSessionId INT4 UNSIGNED NOT NULL, field VARCHAR(20) NOT NULL, value VARCHAR(32) NOT NULL, UNIQUE (cid, usmSessionId, field), FOREIGN KEY(cid, usmSessionId) REFERENCES USMSession(cid, usmSessionId)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE sequence_usmSessionId (cid INT4 UNSIGNED NOT NULL, PRIMARY KEY (cid)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DELIMITER //
CREATE PROCEDURE get_sequence_usmSessionId_id(IN context INT4 UNSIGNED) NOT DETERMINISTIC MODIFIES SQL DATA
BEGIN
    UPDATE sequence_usmSessionId SET id=id+1 WHERE cid=context;
    SELECT id FROM sequence_usmSessionId WHERE cid=context;
END //
DELIMITER ;





