/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.session.sync;

import com.openexchange.usm.api.session.DataObject;

/**
 * 
 * @author afe
 *
 */
public class CachedOXData {
	private final long _timestamp;
	private final DataObject[] _data;
	private boolean _syncComplete;

	public CachedOXData(long timestamp, DataObject[] data) {
		_timestamp = timestamp;
		_data = createCopy(data);
	}

	public long getTimestamp() {
		return _timestamp;
	}

	public DataObject[] getData() {
		return createCopy(_data);
	}

	public void setSyncComplete(boolean syncComplete) {
		_syncComplete = syncComplete;
	}

	public boolean isSyncComplete() {
		return _syncComplete;
	}

	private DataObject[] createCopy(DataObject[] data) {
		if (data == null)
			return null;
		DataObject[] result = new DataObject[data.length];
		for (int i = 0; i < data.length; i++)
			result[i] = data[i].createCopy(false);
		return result;
	}
}
