/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.json.response;

/**
 * List of status codes to be returned in the response.  
 * @author ldo
 *
 */
public enum ResponseStatusCode {

	/**
	 * The command was completed successfully 
	 */
	SUCCESS,

	/**
	 * Unexpected Error occurred when accessing the OX server.
	 */
	OX_SERVER_ERROR,

	/**
	 * Unexpected Error occurred when accessing the Database.
	 */
	DATABASE_ERROR,

	/**
	 * Unexpected error in USM.
	 */
	INTERNAL_ERROR,

	/**
	 * Could not login to USM/OX.
	 */
	ACCESS_DENIED,

	/**
	 * The session-id does not exist. 
	 */
	UNKNOWN_SESSION,

	/**
	 * The UUID does not exist. 
	 */
	UNKNOWN_UUID,

	/**
	 * Wrong parameter types or missing parameters in the request. 
	 */
	WRONG_MISSING_PARAMETERS,

	/**
	 * Synchronization failed because of Conflicts. 
	 */
	SYNC_FAILED,

	/**
	 * Bad request. 
	 */
	BAD_REQUEST,

	/**
	 * A SyncID was provided that is not known by the USM. A valid SyncID or a slow sync is required.
	 */
	UNKNOWN_SYNCID,

	/**
	 * During login a version of the USM/JSON-API was requested that is not supported by the USM server
	 */
	UNSUPPORTED_VERSION,

	/**
	 * A specified folder was not found by the USM/OX server. A synchronization of the folder hierarchy
	 * should be performed to get its current structure.
	 */
	FOLDER_NOT_FOUND,

	/**
	 * An element was not found on the server with the specified UID (not to be confused with UUID!)
	 */
	UNKNOWN_UID,
	
	/**
	 * Client time is too old/ too new. 
	 */
	UNALLOWED_CLIENT_TIME,
	
	/**
	 * Server/Resource/Subsystem is temporary down or busy. 
	 */
	TEMPORARY_NOT_AVAILABLE,
	
    /**
     * The command was completed successfully, but objects too large for synchronization were filtered out. Supported since protocol version 1.6.10!
     */
	SUCCESS_FILTERED_OUT_LARGE_OBJECTS;

	public int getStatusCode() {
		return ordinal() + 1;
	}
}
