/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.database.ox;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import com.openexchange.database.DatabaseService;
import com.openexchange.groupware.update.UpdateTaskV2;
import com.openexchange.groupware.update.UpdateTaskProviderService;
import com.openexchange.usm.database.ox.update.USMChangeCollationToUtf8mb4UpdateTaskV2;
import com.openexchange.usm.database.ox.update.ChangeCollationUpdateTask;
import com.openexchange.usm.database.ox.update.USMCreatePrimaryKeyUpdateTask;
import com.openexchange.usm.database.ox.update.USMDeleteStoredProceduresUpdateTaskV2;
import com.openexchange.usm.database.ox.update.USMTablesUpdateTaskV2;
import com.openexchange.usm.database.ox.update.USMUUIDTablesUpdateTaskV2;

public class USMUpdateTaskProvider implements UpdateTaskProviderService {

    private DatabaseService _service;

    /**
     * Initializes a new {@link USMUpdateTaskProvider}.
     * 
     * @param dbService
     */
    public USMUpdateTaskProvider(DatabaseService dbService) {
        _service = dbService;
    }

    @Override
    public Collection<UpdateTaskV2> getUpdateTasks() {
        List<UpdateTaskV2> updateTasks = new ArrayList<UpdateTaskV2>();
        updateTasks.add(new USMTablesUpdateTaskV2(this));
        updateTasks.add(new USMUUIDTablesUpdateTaskV2(this));
        // updateTasks.add(new USMClearTablesUpdateTaskV2(this)); // Do not provide this to prevent unnecessary deletion of database content
        // which would cause slow syncs
        updateTasks.add(new ChangeCollationUpdateTask(this));
        updateTasks.add(new USMCreatePrimaryKeyUpdateTask(this));
        updateTasks.add(new USMDeleteStoredProceduresUpdateTaskV2(this));
        updateTasks.add(new USMChangeCollationToUtf8mb4UpdateTaskV2(this));
        return updateTasks;
    }

    public DatabaseService getDatabaseService() {
        return _service;
    }

}
