/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.contenttypes.folder.impl;

import java.util.BitSet;
import com.openexchange.usm.api.contenttypes.folder.FolderContentType;
import com.openexchange.usm.api.contenttypes.folder.OXFolderContent;
import com.openexchange.usm.api.contenttypes.resource.ResourceInputStream;
import com.openexchange.usm.api.contenttypes.transferhandlers.FolderContentTypeTransferHandler;
import com.openexchange.usm.api.datatypes.PIMAttachment;
import com.openexchange.usm.api.datatypes.PIMAttachments;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.ox.json.OXJSONAccess;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.api.session.DataObjectFilter;
import com.openexchange.usm.api.session.Folder;
import com.openexchange.usm.api.session.Session;

public class FolderContentTypeTransferHandlerDelegator implements FolderContentTypeTransferHandler {

    private final FolderContentTypeImpl _contentType;

    private final OXJSONAccess _ajaxAccess;

    private final Folder2ContentTypeTransferHandlerImpl _folder2ContentTypeTransferHandlerImpl;

    private final FolderContentTypeTransferHandlerImpl _folderContentTypeTransferHandlerImpl;

    protected FolderContentTypeTransferHandlerDelegator(FolderContentTypeImpl contentType,  OXJSONAccess ajaxAccess) {
        _contentType = contentType;
        _ajaxAccess = ajaxAccess;
        _folder2ContentTypeTransferHandlerImpl = new Folder2ContentTypeTransferHandlerImpl(_contentType, _ajaxAccess);
        _folderContentTypeTransferHandlerImpl = new FolderContentTypeTransferHandlerImpl(_contentType, _ajaxAccess);
    }

    @Override
    public void readFolder(Folder object, BitSet requestedFields) throws USMException {
        getTransferHandlerImplementation(object).readFolder(object, requestedFields);
    }

    @Override
    public Folder[] readFolderContent(Folder folder) throws USMException {
        return getTransferHandlerImplementation(folder).readFolderContent(folder);
    }

    @Override
    public OXFolderContent readFolderContent(Folder folder, int limit, DataObjectFilter filter) throws USMException {
        return getTransferHandlerImplementation(folder).readFolderContent(folder, limit, filter);
    }

    @Override
    public Folder[] readFolderContent(Folder folder, BitSet requestedFields) throws USMException {
        return getTransferHandlerImplementation(folder).readFolderContent(folder, requestedFields);
    }

    @Override
    public Folder[] readRootFolders(Session session, BitSet requestedFields) throws USMException {
        return getTransferHandlerImplementation(session).readRootFolders(session, requestedFields);
    }

    @Override
    public Folder[] readUpdatedFolderContent(Folder folder, BitSet requestedFields, long timestamp) throws USMException {
        return getTransferHandlerImplementation(folder).readUpdatedFolderContent(folder, requestedFields, timestamp);
    }

    @Override
    public void writeDeletedFolder(Folder object) throws USMException {
        getTransferHandlerImplementation(object).writeDeletedFolder(object);
    }

    @Override
    public void writeNewFolder(Folder object) throws USMException {
        getTransferHandlerImplementation(object).writeNewFolder(object);
    }

    @Override
    public void writeUpdatedFolder(Folder object, long timestamp) throws USMException {
        getTransferHandlerImplementation(object).writeUpdatedFolder(object, timestamp);
    }

    @Override
    public void readDataObject(DataObject object, BitSet requestedFields) throws USMException {
        getTransferHandlerImplementation(object).readDataObject(object, requestedFields);
    }

    @Override
    public void writeDeletedDataObject(DataObject object) throws USMException {
        getTransferHandlerImplementation(object).writeDeletedDataObject(object);
    }

    @Override
    public void writeNewDataObject(DataObject object) throws USMException {
        getTransferHandlerImplementation(object).writeNewDataObject(object);
    }

    @Override
    public void writeUpdatedDataObject(DataObject object, long timestamp) throws USMException {
        getTransferHandlerImplementation(object).writeUpdatedDataObject(object, timestamp);
    }

    @Override
    public PIMAttachments getAllAttachments(DataObject object) throws USMException {
        return getTransferHandlerImplementation(object).getAllAttachments(object);
    }

    @Override
    public long createNewAttachment(DataObject object, PIMAttachment attachment) throws USMException {
        return getTransferHandlerImplementation(object).createNewAttachment(object, attachment);
    }

    @Override
    public long deleteAttachments(DataObject object, PIMAttachment... attachmentsToDelete) throws USMException {
        return getTransferHandlerImplementation(object).deleteAttachments(object, attachmentsToDelete);
    }

    @Override
    public byte[] getAttachmentData(DataObject object, int attachmentId) throws USMException {
        return getTransferHandlerImplementation(object).getAttachmentData(object, attachmentId);
    }

    @Override
    public ResourceInputStream getAttachmentDataStream(DataObject object, int attachmentId, long offset, long length) throws USMException {
        return getTransferHandlerImplementation(object).getAttachmentDataStream(object, attachmentId, offset, length);
    }

    private FolderContentTypeTransferHandler getTransferHandlerImplementation(DataObject object) {
        return getTransferHandlerImplementation(object.getSession());
    }

    private FolderContentTypeTransferHandler getTransferHandlerImplementation(Session session) {
        String folderTree = session.getPersistentField(FolderContentType.FOLDER_TREE);
        if (folderTree != null && folderTree.length() > 0) {
            return _folder2ContentTypeTransferHandlerImpl;
        }
        return _folderContentTypeTransferHandlerImpl;
    }
}
