/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.configuration.osgi;

import com.openexchange.config.ConfigurationService;
import com.openexchange.usm.api.configuration.ConfigurationManager;
import com.openexchange.usm.configuration.ox.ConfigurationManagerAdapter;
import com.openexchange.usm.util.AbstractUSMActivator;

/**
 * {@link ConfigurationManagerActivator}
 * 
 * @author <a href="mailto:ioannis.chouklis@open-xchange.com">Ioannis Chouklis</a>
 */
public class ConfigurationManagerActivator extends AbstractUSMActivator {

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.util.AbstractUSMActivator#getNeededServices()
     */
    @Override
    protected Class<?>[] getNeededServices() {
        return new Class<?>[] { ConfigurationService.class };
    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.util.AbstractUSMActivator#register(org.osgi.framework.BundleContext)
     */
    @Override
    protected void register() {
        ConfigurationService configService = (ConfigurationService) context.getService(presentServices.get(ConfigurationService.class));

        ConfigurationManager cm = new ConfigurationManagerAdapter(configService);
        registerService(ConfigurationManager.class, cm);

        LOG.info("ConfigurationManager registered.");
    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.util.AbstractUSMActivator#unregister(org.osgi.framework.BundleContext)
     */
    @Override
    protected void unregister() {
        ConfigurationManagerAdapter cm = (ConfigurationManagerAdapter) getRegisteredService(ConfigurationManager.class);
        if (cm != null)
            cm.deactivate();
        LOG.info("ConfigurationManager unregistered.");
    }
}
