/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.api.contenttypes.transferhandlers;

import java.util.BitSet;
import com.openexchange.usm.api.contenttypes.folder.OXFolderContent;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.session.DataObjectFilter;
import com.openexchange.usm.api.session.Folder;
import com.openexchange.usm.api.session.Session;

/**
 * Handler for the entire interaction with the OX server for the Folder Content Type.
 * 
 * @author ldo
 */
public interface FolderContentTypeTransferHandler extends ContentTypeTransferHandler {

    String MODULE_SYSTEM = "system";

    /**
     * Same as readDataObject, but uses the more specific interface Folder for its parameter.
     * 
     * @param object
     * @param requestedFields
     * @throws USMException
     */
    void readFolder(Folder object, BitSet requestedFields) throws USMException;

    /**
     * Defines more specific return type than generic interface
     * 
     * @param object
     * @throws USMException
     */
    @Override
    Folder[] readFolderContent(Folder folder) throws USMException;

    /**
     * Defines more specific return type than generic interface
     * 
     * @param object
     * @param limit
     * @param filter
     * @throws USMException
     */
    @Override
    OXFolderContent readFolderContent(Folder folder, int limit, DataObjectFilter filter) throws USMException;

    /**
     * Defines more specific return type than generic interface
     * 
     * @param object
     * @param requestedFields
     * @throws USMException
     */
    @Override
    Folder[] readFolderContent(Folder folder, BitSet requestedFields) throws USMException;

    /**
     * Defines more specific return type than generic interface
     * 
     * @param folder
     * @param requestedFields
     * @param timestamp
     * @throws USMException
     */
    @Override
    Folder[] readUpdatedFolderContent(Folder folder, BitSet requestedFields, long timestamp) throws USMException;

    /**
     * Same as writeDeletedDataObject, but uses the more specific interface Folder for its parameter.
     * 
     * @param object
     * @throws USMException
     */
    void writeDeletedFolder(Folder object) throws USMException;

    /**
     * Same as writeNewDataObject, but uses the more specific interface Folder for its parameter.
     * 
     * @param object
     * @throws USMException
     */
    void writeNewFolder(Folder object) throws USMException;

    /**
     * Same as writeUpdatedDataObject, but uses the more specific interface Folder for its parameter.
     * 
     * @param object
     * @throws USMException
     */
    void writeUpdatedFolder(Folder object, long timestamp) throws USMException;

    /**
     * Additional method for Folder ContentType that provides all root folders.
     * 
     * @param session
     * @param requestedFields
     * @return
     * @throws USMException
     */
    Folder[] readRootFolders(Session session, BitSet requestedFields) throws USMException;
}
