/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.api.contenttypes.contact;

import java.util.BitSet;
import java.util.List;
import java.util.Map;
import com.openexchange.usm.api.contenttypes.common.ContentType;
import com.openexchange.usm.api.exceptions.AuthenticationFailedException;
import com.openexchange.usm.api.exceptions.InternalUSMException;
import com.openexchange.usm.api.exceptions.OXCommunicationException;
import com.openexchange.usm.api.exceptions.PictureConversionException;
import com.openexchange.usm.api.exceptions.UnsupportedContentOperationException;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.api.session.Session;

/**
 * Provides all relevant information about the Contact content type.
 * 
 * @author ldo
 */
public interface ContactContentType extends ContentType {

    /**
     * Resolves mail recipients from the user's contacts.
     * 
     * @param toList
     * @param session
     * @param requestedFields
     * @return
     * @throws AuthenticationFailedException
     * @throws OXCommunicationException
     * @throws UnsupportedContentOperationException
     */
    Map<String, DataObject[]> resolveRecipients(List<String> toList, Session session, BitSet requestedFields) throws AuthenticationFailedException, OXCommunicationException, UnsupportedContentOperationException, InternalUSMException;

    /**
     * Gets the contacts picture as byte array.
     * 
     * @param dataObject
     * @param pictureFormat
     * @param maxSize
     * @return
     * @throws AuthenticationFailedException
     * @throws OXCommunicationException
     * @throws PictureConversionException
     */
    byte[] getPictureData(DataObject dataObject, String pictureFormat, int maxSize) throws AuthenticationFailedException, OXCommunicationException, PictureConversionException;

    /**
     * Gets all registered users from the user interface.
     * 
     * @param session
     * @param requestedFields
     * @return
     * @throws AuthenticationFailedException
     * @throws OXCommunicationException
     * @throws UnsupportedContentOperationException
     * @throws InternalUSMException
     */
    DataObject[] getAllUsers(Session session, BitSet requestedFields) throws AuthenticationFailedException, OXCommunicationException, UnsupportedContentOperationException, InternalUSMException;

    /**
     * Gets all data for a specific user.
     * 
     * @param object
     * @param requestedFields
     * @return
     * @throws AuthenticationFailedException
     * @throws OXCommunicationException
     * @throws UnsupportedContentOperationException
     * @throws InternalUSMException
     */
    void getUser(DataObject object, BitSet requestedFields) throws AuthenticationFailedException, OXCommunicationException, UnsupportedContentOperationException, InternalUSMException;
}
