/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.session.storage.sql.impl;

public class SyncStateStorageSQLStatements {

	public static final String FULL_INSERT = "INSERT INTO USMDataStorage (cid, usmSessionId, objectId, syncKey, element) VALUES (?, ?, ?, ?, ?)";
	
	public static final String FULL_INSERT_IGNORE = "INSERT IGNORE INTO USMDataStorage (cid, usmSessionId, objectId, syncKey, element) VALUES (?, ?, ?, ?, ?)";

	public static final String DELETE = "DELETE FROM USMDataStorage WHERE ";

	public static final String SELECT_CACHED_DATA = "SELECT syncKey, element FROM USMDataStorage WHERE ";

	public static final String SELECT_CACHED_DATA_ORDER_BY = " ORDER BY syncKey DESC LIMIT ?";

	public static final String UNIQUE_SESSION_IDENTIFIER = "cid = ? AND usmSessionId = ?";

	public static final String UNIQUE_OBJECT_IDENTIFIER = UNIQUE_SESSION_IDENTIFIER + " AND objectId = ?";

	public static final String SINGLE_ELEMENT_IDENTIFIER = UNIQUE_OBJECT_IDENTIFIER + " AND syncKey = ?";

	public static final String CACHE_DELETE_CONDITION_SIMPLE = " AND syncKey < ?";

	public static final String CACHE_DELETE_CONDITION_EXTENSION = " AND syncKey != ?";

	public static final String SELECT_OBJECT_IDS = "SELECT DISTINCT objectId FROM USMDataStorage WHERE " + UNIQUE_SESSION_IDENTIFIER;
	
	public static final String SIMPLE_SYNCSTATE_DELETE = DELETE + UNIQUE_OBJECT_IDENTIFIER + CACHE_DELETE_CONDITION_SIMPLE;
	
    public static final String COMPLEX_SYNCSTATE_DELETE = SIMPLE_SYNCSTATE_DELETE + CACHE_DELETE_CONDITION_EXTENSION;
    
    public static final String UPDATE = "UPDATE USMDataStorage SET objectId = ? WHERE objectId = ? AND cid = ? AND usmSessionId = ?";
}
