
package com.openexchange.usm.session.impl;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.user.User;
import com.openexchange.user.interceptor.UserServiceInterceptor;
import com.openexchange.usm.api.exceptions.AuthenticationFailedException;
import com.openexchange.usm.api.exceptions.OXCommunicationException;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.ox.json.OXJSONAccess;
import com.openexchange.usm.api.session.assets.SessionID;
import com.openexchange.usm.api.session.assets.UserID;
import com.openexchange.usm.session.storage.SessionStorage;

/**
 * UserInterceptor - gets invoked on user creation/changes via admin interface (command line tool).
 *
 * @author<a href="mailto:ljupka.grabsch@microdoc.com">Ljupka Grabsch</a>
 */
public class USMUserServiceInterceptor implements UserServiceInterceptor {

    OXJSONAccess _oxAjaxAccess;

    SessionManagerImpl _sessionManager;

    private static final transient Log LOG = LogFactory.getLog(USMUserServiceInterceptor.class);

    public USMUserServiceInterceptor(OXJSONAccess _oxAjaxAccess, SessionManagerImpl _sessionManager) {
        this._oxAjaxAccess = _oxAjaxAccess;
        this._sessionManager = _sessionManager;
    }

    @Override
    public int getRanking() {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public void beforeCreate(Context context, User user, Contact contactData) throws OXException {
        // TODO Auto-generated method stub

    }

    @Override
    public void afterCreate(Context context, User user, Contact contactData) throws OXException {
        // TODO Auto-generated method stub

    }

    @Override
    public void beforeUpdate(Context context, User user, Contact contactData, Map<String, Object> properties) throws OXException {
        // TODO Auto-generated method stub

    }

    @Override
    public void afterUpdate(Context context, User user, Contact contactData, Map<String, Object> properties) throws OXException {
        if(user == null) {
            return; //user not affected, only contact data has changed
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("after update method in user interceptor, for user: " + user.getId());
        }
        try {
            SessionStorage sessionStorage = _sessionManager.getSessionStorage();
            SessionID[] sessions = sessionStorage != null ? sessionStorage.getActiveSessions(new UserID(context.getContextId(), user.getId())) : null;
            if (sessionStorage == null || sessions == null) {
                return;
            }
            for (SessionID sessionID : sessions) {
                SessionImpl session = sessionStorage.getSession(sessionID);
                if (session != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("session found: " + sessionID + " ... reading config and reinitialize session");
                    }
                    JSONObject configuration = _oxAjaxAccess.getConfiguration(session);
                    session.getSessionInitializer().reinitializeSession(session, configuration);
                }
            }
        } catch (AuthenticationFailedException e) {
            LOG.error("Authentication failed on reading config ", e);
        } catch (OXCommunicationException e) {
            LOG.error("OXCommunication exception on reading the config ", e);
        } catch (USMException e) {
            LOG.error("USMException on reading the config ", e);
        }
    }

    @Override
    public void beforeDelete(Context context, User user, Contact contactData) throws OXException {
        // TODO Auto-generated method stub

    }

    @Override
    public void afterDelete(Context context, User user, Contact contactData) throws OXException {
        // TODO Auto-generated method stub

    }

}
