/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.session.impl;

import java.util.Arrays;
import java.util.List;
import com.openexchange.usm.api.session.ObjectChanges;

public class ObjectChangesImpl implements ObjectChanges {
	private final static String[] EMPTY_ARRAY = new String[0];

	public static ObjectChanges create(boolean folderStructureChanged, List<String> changedFolders) {
		if (!folderStructureChanged && changedFolders.isEmpty())
			return null;
		return new ObjectChangesImpl(folderStructureChanged, changedFolders);
	}

	private final boolean _folderStructureChanged;

	private final String[] _contentChangeParentIDs;

	public ObjectChangesImpl(boolean folderStructureChanged, List<String> changedFolders) {
		this(folderStructureChanged, changedFolders.isEmpty() ? EMPTY_ARRAY : changedFolders
				.toArray(new String[changedFolders.size()]));
	}

	public ObjectChangesImpl(boolean folderStructureChanged, String... folderChanges) {
		_folderStructureChanged = folderStructureChanged;
		_contentChangeParentIDs = folderChanges;
	}

	@Override
    public String[] getContentChangeParentIDs() {
		return _contentChangeParentIDs;
	}

	@Override
	public String toString() {
		return "FolderChanges: " + _folderStructureChanged + ", ContentChanges: "
				+ Arrays.toString(_contentChangeParentIDs);
	}

	@Override
    public boolean hasFolderStructureChanged() {
		return _folderStructureChanged;
	}
}
