/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.session.dataobject;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import com.openexchange.usm.api.contenttypes.common.ContentType;
import com.openexchange.usm.api.contenttypes.common.ContentTypeField;
import com.openexchange.usm.api.contenttypes.common.FieldMapStorage;

public class FieldMapStorageImpl implements FieldMapStorage {

    private final static FieldMapStorageImpl INSTANCE = new FieldMapStorageImpl();

    public static FieldMapStorageImpl getInstance() {
        return INSTANCE;
    }

    private final ConcurrentMap<ContentType, Map<String, Integer>> _fieldNameToIndexMapTable = new ConcurrentHashMap<ContentType, Map<String, Integer>>(
        16,
        0.75f,
        1);

    @Override
    public void addedContentType(ContentType typeAdded) {
        _fieldNameToIndexMapTable.remove(typeAdded);
    }

    @Override
    public void removedContentType(ContentType typeRemoved) {
        _fieldNameToIndexMapTable.remove(typeRemoved);
    }

    @Override
    public Map<String, Integer> getFieldNameToIndexMap(ContentType contentType) {
        Map<String, Integer> result = _fieldNameToIndexMapTable.get(contentType);
        if (result == null) { // TODO: initialize in activate
            result = new HashMap<String, Integer>();
            ContentTypeField[] fields = contentType.getFields();
            for (int i = 0; i < fields.length; i++)
                result.put(fields[i].getFieldName(), i);
            _fieldNameToIndexMapTable.putIfAbsent(contentType, result);
        }
        return result;
    }
}
