/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.ox_json.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.RequestEntity;
import com.openexchange.usm.api.io.InputStreamProvider;

/**
 * {@link InputStreamProviderRequestEntity} Special RequestEntity that provides data from an InputStreamProvider
 * 
 * @author <a href="mailto:afe@microdoc.de">Alexander Feess</a>
 */
public class InputStreamProviderRequestEntity implements RequestEntity {

    private final InputStreamProvider _provider;

    public InputStreamProviderRequestEntity(InputStreamProvider provider) {
        _provider = provider;
    }

    /*
     * (non-Javadoc)
     * @see org.apache.commons.httpclient.methods.RequestEntity#getContentLength()
     */
    @Override
    public long getContentLength() {
        return -1L;
    }

    /*
     * (non-Javadoc)
     * @see org.apache.commons.httpclient.methods.RequestEntity#getContentType()
     */
    @Override
    public String getContentType() {
        return null;
    }

    /*
     * (non-Javadoc)
     * @see org.apache.commons.httpclient.methods.RequestEntity#isRepeatable()
     */
    @Override
    public boolean isRepeatable() {
        return true;
    }

    /*
     * (non-Javadoc)
     * @see org.apache.commons.httpclient.methods.RequestEntity#writeRequest(java.io.OutputStream)
     */
    @Override
    public void writeRequest(OutputStream os) throws IOException {
        InputStream is = _provider.getInputStream();
        try {
            byte[] buffer = new byte[8192];
            int read = 0;
            while ((read = is.read(buffer)) >= 0)
                os.write(buffer, 0, read);
            is.close();
        } catch (IOException e) {
            try {
                is.close();
            } catch (IOException ignored) {
                // Ignore IOException when closing after error to throw the original error
            }
            throw e;
        }
    }

}
