/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.ox_json.impl;

import static com.openexchange.usm.api.ox.json.JSONResultType.JSONArray;
import static com.openexchange.usm.api.ox.json.JSONResultType.JSONObject;
import static com.openexchange.usm.api.ox.json.JSONResultType.String;
import org.json.JSONArray;
import org.json.JSONObject;
import com.openexchange.usm.api.exceptions.USMIllegalStateException;
import com.openexchange.usm.api.ox.json.JSONResult;
import com.openexchange.usm.api.ox.json.JSONResultType;

public abstract class AbstractJSONResult implements JSONResult {

    @Override
    public JSONArray getJSONArray() {
        throw new USMIllegalStateException(OXJSONErrorCode.ABSTRACT_JSONRESULT_NUMBER_0, getErrorMessage(JSONArray));
    }

    @Override
    public JSONObject getJSONObject() {
        throw new USMIllegalStateException(OXJSONErrorCode.ABSTRACT_JSONRESULT_NUMBER_1, getErrorMessage(JSONObject));
    }

    @Override
    public String getString() {
        throw new USMIllegalStateException(OXJSONErrorCode.ABSTRACT_JSONRESULT_NUMBER_2, getErrorMessage(String));
    }

    private String getErrorMessage(JSONResultType expected) {
        return "Result from OX server is a " + getResultType() + ", expected " + expected;
    }

    @Override
    public String toString() {
        return "OX Result: " + toJSONString();
    }
}
