/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.mimemail;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.ExecutorService;
import com.openexchange.usm.api.io.InputStreamProvider;
import com.openexchange.usm.json.USMJSONServlet;
import com.openexchange.usm.util.Toolkit;

/**
 * {@link MailInputStreamProvider}
 *
 * @author <a href="mailto:afe@microdoc.de">Alexander Feess</a>
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a> Added delegation to thread pool if available & JavaDoc
 */
public class MailInputStreamProvider implements InputStreamProvider {

    final USMMimeMessage _message;

    /**
     * Initializes a new {@link MailInputStreamProvider}.
     *
     * @param message The MIME message
     */
    public MailInputStreamProvider(USMMimeMessage message) {
        _message = message;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        final ExtendedPipedInputStream in = new ExtendedPipedInputStream();
        final PipedOutputStream out = new PipedOutputStream(in);

        final Runnable r = new Runnable() {

            @Override
            public void run() {
                try {
                    _message.writeTo(out);
                } catch (Exception e) {
                    in.setException(e);
                } finally {
                    Toolkit.close(out);
                }
            }
        };

        final ExecutorService executor = USMJSONServlet.getExecutorService();
        if (null == executor) {
            new Thread(r, "USM-StreamingMimeMailBuilder").start();
        } else {
            executor.execute(r);
        }

        return in;
    }

}
