/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.json;

import java.io.Serializable;

public class USMSessionCredentials implements Comparable<USMSessionCredentials>, Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private final String _user;

	private final String _device;
	
	private final String _password;
	
	public USMSessionCredentials(String user, String device, String password) {
		_user = user;
		_device = device;
		_password = password;
	}

	public String getUser() {
		return _user;
	}

	public String getDevice() {
		return _device;
	}

	public String getPassword() {
		return _password;
	}
	
	@Override
    public int compareTo(USMSessionCredentials o) {
		int result = _user.compareTo(o._user);
		if (result == 0) {
			result = _password.compareTo(o._password);
			if (result == 0)
				result = _device.compareTo(o._device);
		}
		return result;
	}

	@Override
	public String toString() {
		return _user + ':' + ':' + _device;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((_device == null) ? 0 : _device.hashCode());
		result = prime * result + ((_password == null) ? 0 : _password.hashCode());
		result = prime * result + ((_user == null) ? 0 : _user.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof USMSessionCredentials))
			return false;
		USMSessionCredentials other = (USMSessionCredentials) obj;
		if (_device == null) {
			if (other._device != null)
				return false;
		} else if (!_device.equals(other._device))
			return false;
		if (_password == null) {
			if (other._password != null)
				return false;
		} else if (!_password.equals(other._password))
			return false;
		if (_user == null) {
			if (other._user != null)
				return false;
		} else if (!_user.equals(other._user))
			return false;
		return true;
	}
}
