/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.json;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.openexchange.usm.connector.commands.ClearDataHandler;
import com.openexchange.usm.connector.commands.CommandHandler;
import com.openexchange.usm.connector.commands.DownloadDataHandler;
import com.openexchange.usm.connector.commands.GetCachedDataHandler;
import com.openexchange.usm.connector.commands.GetConfigurationHandler;
import com.openexchange.usm.connector.commands.InvalidateObjectsHandler;
import com.openexchange.usm.connector.commands.LocateObjectsHandler;
import com.openexchange.usm.connector.commands.LoginHandler;
import com.openexchange.usm.connector.commands.LogoutHandler;
import com.openexchange.usm.connector.commands.MoveItemsHandler;
import com.openexchange.usm.connector.commands.PingHandler;
import com.openexchange.usm.connector.commands.ReadDataHandler;
import com.openexchange.usm.connector.commands.ResolveIDsHandler;
import com.openexchange.usm.connector.commands.ResolveRecipientsHandler;
import com.openexchange.usm.connector.commands.SendMailHandler;
import com.openexchange.usm.connector.commands.SetConfigurationHandler;
import com.openexchange.usm.connector.commands.SetConfirmationStatusHandler;
import com.openexchange.usm.connector.commands.SetPushNotificationHandler;
import com.openexchange.usm.connector.commands.SyncEstimateHandler;
import com.openexchange.usm.connector.commands.SyncInitHandler;
import com.openexchange.usm.connector.commands.SyncUpdateHandler;
import com.openexchange.usm.connector.commands.UploadDataHandler;
import com.openexchange.usm.json.response.ResponseStatusCode;

/**
 * Creates delegate instance for certain USM-JSON command.
 * 
 * @author ldo
 */
public class CommandDelegateFactory {

    public static CommandHandler createCommandHandler(USMJSONServlet servlet, String command, HttpServletRequest request, HttpServletResponse response) throws USMJSONAPIException {
        if (ServletConstants.USM_LOGIN.equals(command))
            return new LoginHandler(servlet, request);
        if (ServletConstants.USM_LOGOUT.equals(command))
            return new LogoutHandler(servlet, request);
        if (ServletConstants.USM_GET_CONFIGURATION.equals(command))
            return new GetConfigurationHandler(servlet, request);
        if (ServletConstants.USM_SET_CONFIGURATION.equals(command))
            return new SetConfigurationHandler(servlet, request);
        if (ServletConstants.USM_MOVE_ITEMS.equals(command))
            return new MoveItemsHandler(servlet, request);
        if (ServletConstants.USM_READ_DATA.equals(command))
            return new ReadDataHandler(servlet, request);
        if (ServletConstants.USM_RESOLVE_RECIPIENTS.equals(command))
            return new ResolveRecipientsHandler(servlet, request);
        if (ServletConstants.USM_SEND_MAIL.equals(command))
            return new SendMailHandler(servlet, request);
        if (ServletConstants.USM_SET_PUSH_NOTIFICATION.equals(command))
            return new SetPushNotificationHandler(servlet, request);
        if (ServletConstants.USM_SYNC_ESTIMATE.equals(command))
            return new SyncEstimateHandler(servlet, request);
        if (ServletConstants.USM_SYNC_INIT.equals(command))
            return new SyncInitHandler(servlet, request);
        if (ServletConstants.USM_SYNC_UPDATE.equals(command))
            return new SyncUpdateHandler(servlet, request);
        if (ServletConstants.GET_CACHED_DATA.equals(command))
            return new GetCachedDataHandler(servlet, request);
        if (ServletConstants.USM_PING.equals(command))
            return new PingHandler(servlet, request);
        if (ServletConstants.USM_RESOLVE_IDS.equals(command))
            return new ResolveIDsHandler(servlet, request);
        if (ServletConstants.USM_INVALIDATE_OBJECTS.equals(command))
            return new InvalidateObjectsHandler(servlet, request);
        if (ServletConstants.USM_LOCATE_OBJECTS.equals(command))
            return new LocateObjectsHandler(servlet, request);
        if (ServletConstants.USM_SET_CONFIRMATION_STATUS.equals(command))
            return new SetConfirmationStatusHandler(servlet, request);
        if (ServletConstants.USM_DOWNLOAD_DATA.equals(command))
            return new DownloadDataHandler(servlet, request, response);
        if (ServletConstants.USM_UPLOAD_DATA.equals(command))
            return new UploadDataHandler(servlet, request);
        if (ServletConstants.USM_CLEAR_DATA.equals(command))
            return new ClearDataHandler(servlet, request);
        throw new USMJSONAPIException(
            ConnectorBundleErrorCodes.BAD_COMMAND_IN_REQUEST,
            ResponseStatusCode.BAD_REQUEST,
            "Unknown command " + command);
    }
}
