/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.connector.commands;

import com.openexchange.usm.api.session.Session;
import com.openexchange.usm.json.USMJSONAPIException;
import com.openexchange.usm.json.response.ResponseObject;

/**
 * @author afe
 */
public interface CommandHandler {

    /**
     * To be overwritten by child command handlers
     * 
     * @return response object to be sent back to the client. If null is returned, the handler already sent the data and no further actions
     *         are necessary (required for all streaming operations)
     * @throws USMJSONAPIException in case of error
     */
    ResponseObject handleRequest() throws USMJSONAPIException;

    /**
     * @return Session associated with the Command, or null if no Session can be associated (or hasn't been associated yet)
     */
    Session getSession();

    /**
     * Called after execution of the command has finished and the response has been generated. Here the CommandHandler can cleanup any
     * temporary resources it allocated. Also for command-sequences, here the final command can cleanup any data that was created during the
     * command sequence.
     */
    void disposeResources();
}
