/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.contenttypes.tasks.impl;

import java.util.BitSet;
import com.openexchange.usm.api.contenttypes.folder.OXFolderContent;
import com.openexchange.usm.api.contenttypes.task.TaskConstants;
import com.openexchange.usm.api.contenttypes.task.TaskContentType;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.ox.json.OXJSONAccess;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.api.session.DataObjectFilter;
import com.openexchange.usm.api.session.Folder;
import com.openexchange.usm.contenttypes.util.AbstractTransferHandler;

/**
 * Transfer Handler for the module "Tasks"
 * @author ldo
 *
 */
public class TaskContentTypeTransferHandlerImpl extends AbstractTransferHandler {

	public TaskContentTypeTransferHandlerImpl(TaskContentType contentType, OXJSONAccess access) {
		super(contentType, access);
	}

	@Override
	protected String getOXAjaxAccessPath() {
		return TaskConstants.TASK_PATH;
	}

    @Override
    public OXFolderContent readFolderContent(Folder folder, int limit, DataObjectFilter filter) throws USMException {
        OXFolderContent result = super.readFolderContent(folder, limit, filter);
        resetRecurrenceTypeBasedFields(result.getObjects());
        return result;
    }

	@Override
	public DataObject[] readFolderContent(Folder folder, BitSet requestedFields) throws USMException {
        DataObject[] result = super.readFolderContent(folder, requestedFields);
		resetRecurrenceTypeBasedFields(result);
		return result;
	}

	@Override
	public DataObject[] readUpdatedFolderContent(Folder folder, BitSet requestedFields, long timestamp)
			throws USMException {
		DataObject[] result = super.readUpdatedFolderContent(folder, requestedFields, timestamp);
		resetRecurrenceTypeBasedFields(result);
		return result;
	}

	@Override
	public void writeUpdatedDataObject(DataObject object, long timestamp) throws USMException {
		super.writeUpdatedDataObject(object, timestamp);
		setAppOrTaskConfirmations(object);
	}
	
}
