/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.datatypes.tasks.calendar;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.usm.api.datatypes.AbstractDataType;
import com.openexchange.usm.api.session.Session;

public class ConfirmingParticipantDataType extends AbstractDataType<ConfirmingParticipant> {
	
    public ConfirmingParticipantDataType() {
	    super("ConfirmingParticipant");
	}

	@Override
    public void addToJSONArray(Session session, JSONArray parent, Object value) throws JSONException {
		parent.put(((ConfirmingParticipant) value).toJSONObject());
	}

	@Override
    public ConfirmingParticipant checkValue(Object o) {
		if (o != null && !(o instanceof ConfirmingParticipant))
			generateTypeError(o);
		return (ConfirmingParticipant) o;
	}

	@Override
    public ConfirmingParticipant extractFromJSONArray(Session session, JSONArray array, int index) throws JSONException {
		return array.isNull(index) ? new ConfirmingParticipant() : new ConfirmingParticipant(array.getJSONObject(index));
	}

	@Override
    public ConfirmingParticipant extractFromJSONObject(Session session, JSONObject jsonObject, String field)
			throws JSONException {
		return jsonObject.isNull(field) ? new ConfirmingParticipant() : new ConfirmingParticipant(jsonObject.getJSONObject(field));
	}

	@Override
    public void storeInJSONObject(Session session, JSONObject parent, String field, Object value) throws JSONException {
		parent.put(field, ((ConfirmingParticipant) value).toJSONObject());
	}
}
