/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.contenttypes.resources.impl;

import static com.openexchange.usm.api.datatypes.DataTypes.BOOLEAN;
import static com.openexchange.usm.api.datatypes.DataTypes.STRING;
import java.util.BitSet;
import com.openexchange.usm.api.contenttypes.common.CommonConstants;
import com.openexchange.usm.api.contenttypes.common.ContentTypeField;
import com.openexchange.usm.api.contenttypes.common.DefaultContentTypes;
import com.openexchange.usm.api.contenttypes.resource.ResourceContentType;
import com.openexchange.usm.api.contenttypes.resource.ResourcesConstants;
import com.openexchange.usm.api.contenttypes.transferhandlers.ContentTypeTransferHandler;
import com.openexchange.usm.api.exceptions.AuthenticationFailedException;
import com.openexchange.usm.api.exceptions.InternalUSMException;
import com.openexchange.usm.api.exceptions.OXCommunicationException;
import com.openexchange.usm.api.exceptions.UnsupportedContentOperationException;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.api.session.Session;
import com.openexchange.usm.contenttypes.util.AbstractContentType;

public class ResourcesContentTypeImpl extends AbstractContentType implements ResourceContentType {

    private static final ContentTypeField[] FIELDS = {
        new ContentTypeField(0, CommonConstants.FIELD_ID, STRING, false, true, false, false), // ID
        new ContentTypeField(-1901, CommonConstants.FOLDER_ID, STRING, false, false, true, false), // Object ID of the parent folder. Dummy
                                                                                                   // field. Always empty
        new ContentTypeField(2, ResourcesConstants.DISPLAY_NAME, STRING), // Display Name
        new ContentTypeField(-1903, ResourcesConstants.NAME, STRING), // internal Name
        new ContentTypeField(4, ResourcesConstants.MAIL_ADDRESS, STRING), // email address
        new ContentTypeField(-1905, ResourcesConstants.AVAILABILITY, BOOLEAN), // availability
        new ContentTypeField(-1906, ResourcesConstants.DESCRIPTION, STRING), // description
    };

    private ResourcesContentTypeTransferHandler _transferHandler;

    @Override
    public int getCode() {
        return DefaultContentTypes.RESOURCES_CODE;
    }

    @Override
    public ContentTypeField[] getFields() {
        return FIELDS;
    }

    @Override
    public String getID() {
        return DefaultContentTypes.RESOURCES_ID;
    }

    @Override
    public Object getObjectGroupOwner(DataObject object) {
        return object.getID();
    }

    @Override
    public ContentTypeTransferHandler getTransferHandler() {
        return _transferHandler;
    }

    public void setTransferHandler(ResourcesContentTypeTransferHandler transferHandler) {
        _transferHandler = transferHandler;
    }

    @Override
    public DataObject[] getAllResources(Session session, BitSet requestedFields) throws AuthenticationFailedException,
            OXCommunicationException, UnsupportedContentOperationException, InternalUSMException {
        return _transferHandler.getAllResources(session, requestedFields);
    }

    @Override
    public void getResource(DataObject object, BitSet requestedFields) throws AuthenticationFailedException,
            OXCommunicationException, InternalUSMException, UnsupportedContentOperationException {
        _transferHandler.getResource(object, requestedFields);
    }

    @Override
    public boolean supportsPIMAttachments() {
        return false;
    }

    @Override
    public int hashCode() {
        return 201731;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof ResourceContentType))
            return false;
        return true;
    }

    @Override
    public boolean canBeFolderElementsContentType() {
        return false;
    }

}
