/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.contenttypes.manager.osgi;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import com.openexchange.usm.api.contenttypes.common.ContentTypeManager;
import com.openexchange.usm.contenttypes.manager.impl.ContentTypeManagerImpl;


/**
 * {@link ContentTypeManagerActivator}
 *
 * @author <a href="mailto:ioannis.chouklis@open-xchange.com">Ioannis Chouklis</a>
 */
public class ContentTypeManagerActivator implements BundleActivator{

    private static Log LOG = LogFactory.getLog(ContentTypeManagerActivator.class);
    
    private ServiceRegistration<ContentTypeManager> registration;
    
    /*
     * (non-Javadoc)
     * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
     */
    @Override
    public void start(BundleContext context) throws Exception {
        registration = context.registerService(ContentTypeManager.class, new ContentTypeManagerImpl(context.getBundle().getBundleContext()), null);
        LOG.info("Content Type Manager registered.");
    }

    /*
     * (non-Javadoc)
     * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
     */
    @Override
    public void stop(BundleContext context) throws Exception {
        ContentTypeManagerImpl ctm = (ContentTypeManagerImpl) context.getService(registration.getReference());
        if (ctm != null)
            ctm.deactivate();
        registration.unregister();
        LOG.info("Content Type Manager unregistered.");        
    }

}
