/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.contenttypes.manager.impl;

import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import com.openexchange.usm.api.contenttypes.common.ContentType;

public class ContentTypeServiceTracker extends ServiceTracker<ContentType, ContentType> {

    private final ContentTypeManagerImpl _contentTypeManager;

    public ContentTypeServiceTracker(ContentTypeManagerImpl contentTypeManager) {
        super(contentTypeManager.getBundleContext(), ContentType.class.getName(), null);
        _contentTypeManager = contentTypeManager;
    }

    @Override
    public ContentType addingService(ServiceReference<ContentType> reference) {
        ContentType result = super.addingService(reference);
        if (result != null)
            _contentTypeManager.registerContentType(result);
        return result;
    }

    @Override
    public void removedService(ServiceReference<ContentType> reference, ContentType service) {
        super.removedService(reference, service);
        if (service != null)
            _contentTypeManager.unregisterContentType(service);
    }
}
