/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.api.session.assets;

/**
 * Identifier for an User as represented by OX (i.e. context id and user id)
 * 
 * @author afe
 */
public class UserID {

    private final int _contextId;

    private final int _userId;

    /**
     * Initializes a new {@link UserID} from its context id and user id..
     * 
     * @param contextId
     * @param userId
     */
    public UserID(int contextId, int userId) {
        _contextId = contextId;
        _userId = userId;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + _contextId;
        result = prime * result + _userId;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof UserID))
            return false;
        UserID other = (UserID) obj;
        if (_contextId != other._contextId)
            return false;
        if (_userId != other._userId)
            return false;
        return true;
    }

    public int getContextId() {
        return _contextId;
    }

    public int getUserId() {
        return _userId;
    }
}
