/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.api.session.assets;

/**
 * Possible states for DataObjects. Based on the ChangeState of a
 * DataObjects the appropriate actions/commands will/have to be executed
 * <ul>
 * <li>UNMODIFIED: No actions need to be performed
 * <li>MODIFIED: An already existing object has been changed in at least 1 field
 * <li>CREATED: The object has been newly created
 * <li>DELETED: The object has been deleted
 * </ul>
 * @author afe
 *
 */
public enum ChangeState {
	/**
	 * An already existing object that is not modified
	 */
	UNMODIFIED(4),
	/**
	 * An already existing object is modified
	 */
	MODIFIED(2),
	/**
	 * The object is newly created
	 */
	CREATED(3),
	/**
	 * An existing object has been / should be deleted
	 */
	DELETED(1);

	private final int _sortOrder;

	private ChangeState(int sortOrder) {
		_sortOrder = sortOrder;
	}

	public int getSortOrder() {
		return _sortOrder;
	}
}
