/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.api.session;

/**
 * This object is returned on waitForChanges and provided to the SessionChangeListener.
 * It provides two different types of changes:<br><ul>
 * <li>Changes to the folder structure (e.g. new folder) or folder fields like title
 * <li>Changes to elements in folders (e.g. addition of a new contact, changes to fields of an element)
 * </ul>
 * In both cases the ID of the parent folder containing the modifications is returned.
 * <br>TODO Based on the OX events we might be able to additionally/instead provide the exact list of changed object IDs
 * 
 * @author afe
 *
 */
public interface ObjectChanges {
	/**
	 * Returns true if the folder structure itself has been change, i.e. at least one folder
	 * has changed a field, has been added oder removed.
	 * 
	 * @return true if the folder structure changed
	 */
	boolean hasFolderStructureChanged();

	/**
	 * Returns list of folder IDs in which changes to content elements occurred.
	 * These changes can be new elements, deleted elements, changed or moved (source parent folder is reported) elements.
	 * 
	 * @return ID of parent folders for changes to elements in folders
	 */
	String[] getContentChangeParentIDs();
}
