/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.api.ox.event;

/**
 * Interface for listeners that get notified of changes on folders or their
 * content.
 * 
 * @author afe
 *
 */
public interface OXEventListener {
	/**
	 * Called when a folder itself has changed for a user (i.e. at least one of the fields of the folder has changed).
	 * If the folderID is specified as null, the folderID could not be determined.
	 * 
	 * @param contextID contextID of the user for which a change is reported
	 * @param userID User ID for which a change is reported
	 * @param parentFolderId parent folderID of the folder that has changed
	 * @param timestamp timestamp of the modification (if not available, 0 is reported)
	 */
	void folderChanged(int contextID, int userID, String parentFolderId, long timestamp);

	/**
	 * Called when for a user the content of a folder has changed (i.e. at least one element in
	 * the folder had some modification).
	 * If the folderID is specified as null, the folderID could not be determined.
	 * 
	 * @param contextID contextID of the user for which a change is reported
	 * @param userID User ID for which a change is reported
	 * @param folderId folderID of the folder in which at least 1 element changed
	 * @param timestamp timestamp of the modification (if not available, 0 is reported)
	 */
	void folderContentChanged(int contextID, int userID, String folderId, long timestamp);
	
	void objectDeleted(int contextID, int objectID, int contentType);
	
	void defaultFoldersChanged(int contextID, int userID);
}
