/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.api.mapping.storage;

import com.openexchange.usm.api.database.StorageAccessException;
import com.openexchange.usm.api.exceptions.USMStorageException;


/**
 * This interface ensures backward compatibility with old short to long id folder mapping. 
 * Since v.7.4.1 USM doesn't save any more mappings in a storage system, and therefore there is no need to 
 * implement this interface for future storages. 
 * {@link FolderIDMappingStorage}
 *
 * @author <a href="mailto:ioannis.chouklis@open-xchange.com">Ioannis Chouklis</a>
 */
public interface FolderIDMappingStorage {
   
    /**
     * Returns the longID mapping for the given shortID
     * 
     * @param sessionID
     * @param contextID
     * @param shortID
     * @return
     * @throws StorageAccessException
     * @throws USMStorageException
     */
    public String getLongID(int sessionID, int contextID, int shortID) throws StorageAccessException, USMStorageException;
   

    /**
     * Returns the shortID for the given longID
     * or null if not found.
     * 
     * @param sessionID
     * @param contextID
     * @param longID
     * @return
     * @throws StorageAccessException
     * @throws USMStorageException
     */
public Integer findShortID(int sessionID, int contextID, String longID) throws StorageAccessException, USMStorageException;

}

