/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.api.exceptions;

import org.json.JSONObject;

/**
 * Exception that is generated if access to the USM system is denied.
 * This is currently mapped to the syncml flag in the ajax configuration
 * of the user, but may(will) change in the future.
 * 
 * @author afe
 *
 */
public class USMAccessDeniedException extends USMException {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public USMAccessDeniedException(int errorCode, String message) {
		super(errorCode, message);
	}

	@Override
	public JSONObject getErrorDetailsForJSONResponse() {
		return null;
	}
}
