/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.api.datatypes;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.usm.api.session.Session;

/**
 * DataType for fields that store a String
 * 
 * @author afe
 *
 */
public class StringDataType extends AbstractDataType<String> {
	
    public StringDataType() {
        super("String");
    }

	@Override
    public String checkValue(Object o) {
		if (o == null)
			return null;
		String s = o.toString();
		return (s.length() == 0) ? null : s;
	}

	@Override
    public String extractFromJSONObject(Session session, JSONObject jsonObject, String field) throws JSONException {
		return jsonObject.isNull(field) ? null : jsonObject.getString(field);
	}

	public Object checkValueForWrite(Object o) {
		return (o == null) ? JSONObject.NULL : String.valueOf(o);
	}

	@Override
    public void storeInJSONObject(Session session, JSONObject parent, String field, Object object) throws JSONException {
		parent.put(field, checkValueForWrite(object));
	}

	@Override
    public void addToJSONArray(Session session, JSONArray parent, Object object) {
		parent.put(checkValueForWrite(object));
	}

	@Override
    public String extractFromJSONArray(Session session, JSONArray array, int index) throws JSONException {
		return array.isNull(index) ? null : array.getString(index);
	}
}
