/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.api.datatypes;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.usm.api.session.Session;

/**
 * DataType for fields that store a Number
 * 
 * @author afe
 *
 */
public class NumberDataType extends AbstractDataType<Number> {
	
	public NumberDataType() {
	    super("Number");
	}

	@Override
    public void addToJSONArray(Session session, JSONArray parent, Object object) {
		parent.put(object);
	}

	@Override
    public Number checkValue(Object o) {
		if (o != null && !(o instanceof Number))
			generateTypeError(o);
		return (Number) o;
	}

	@Override
    public Number extractFromJSONArray(Session session, JSONArray array, int index) throws JSONException {
		if (array.isNull(index))
			return null;
		return convertToNumber(array.get(index));
	}

	@Override
    public Number extractFromJSONObject(Session session, JSONObject jsonObject, String field) throws JSONException {
		if (jsonObject.isNull(field))
			return null;
		return convertToNumber(jsonObject.get(field));
	}

	@Override
    public void storeInJSONObject(Session session, JSONObject parent, String field, Object object) throws JSONException {
		parent.put(field, (object == null) ? JSONObject.NULL : (Number) object);
	}
}
