/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.api.contenttypes.common;

/**
 * Contains IDs for the common content types.
 * 
 * @author ldo
 */
public class DefaultContentTypes {

    public static final String CONTACTS_ID = "contacts";

    public static final String MAIL_ID = "mail";

    public static final String CALENDAR_ID = "calendar";

    /**
     * ID that must be used by any implementation of FolderContentType and FolderContentTypeTransferHandler
     */
    public static final String FOLDER_ID = "folder";

    public static final String TASK_ID = "tasks";

    public static final String GROUPS_ID = "groups";

    public static final String RESOURCES_ID = "resources";

    // codes

    public static final int CALENDAR_CODE = 1;

    public static final int TASK_CODE = 4;

    public static final int CONTACTS_CODE = 7;

    public static final int MAIL_CODE = 19;

    public static final int FOLDER_CODE = 20;

    public static final int GROUPS_CODE = 21;

    public static final int RESOURCES_CODE = 22;
}
