/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.api.contenttypes.common;

public class CommonConstants {

	public static final String ID = "id";

	public static final String SESSION = "session";

	public static final String ACTION = "action";

	public static final String ACTION_GET = "get";

	public static final String ACTION_GET_STRUCTURE = "get_structure";

	public static final String ACTION_LIST = "list";

	public static final String ACTION_ROOT = "root";

	public static final String ACTION_ALL = "all";

	public static final String ACTION_UPDATES = "updates";

	public static final String ACTION_UPDATE = "update";
	
	public static final String ACTION_SEARCH = "search";

	public static final String TIMESTAMP = "timestamp";

	public static final String COLUMNS = "columns";

	public static final String RECURRENCE_MASTER = "recurrence_master";

	public static final String FOLDER = "folder";

	public static final String ACTION_NEW = "new";

	public static final String ACTION_DELETE = "delete";

	public static final String ACTION_CONFIRM = "confirm";
	
	public static final String ACTION_IMPORT = "import";
	
	public static final String ACTION_CONVERT = "convert";
	
	public static final String ACTION_ANALYZE = "analyze";
	
	public static final String ACTION_ACCEPT = "accept";
	
	public static final String ACTION_DECLINE = "decline";
	
	public static final String ACTION_TENTATIVE = "tentative";

	public static final String SORT = "sort";

	public static final String ORDER = "order";

	public static final String ASC = "asc";

	public static final String DESC = "desc";

	public static final String IGNORE = "ignore";

	public static final String PARENT = "parent";

	public static final String PARENTFOLDER_ID = "folder_id";

	public static final String FOLDER_PATH = "folders";

	public static final String VIRTUAL_FOLDER_PATH = "folder2";

	public static final String CONTACT_PATH = "contacts";

	public static final String MAIL_PATH = "mail";
	
    public static final String MAILFILTER_AJAX_PATH = "mailfilter";
	
	public static final String USERS_PATH = "user";
	
	public static final String CONVERSION_PATH = "conversion";
	
	public static final String ITIP_PATH = "calendar/itip";

	public static final String START = "start";

	public static final String END = "end";

	// Names of fields in CommonObjectData

	public static final String NUMBER_OF_ATTACHMENTS = "number_of_attachments";

	public static final String PRIVATE_FLAG = "private_flag";

	public static final String CATEGORIES = "categories";

	public static final String LAST_MODIFIED = "last_modified";

	public static final String CREATION_DATE = "creation_date";

	public static final String MODIFIED_BY = "modified_by";

	public static final String CREATED_BY = "created_by";

	public static final String FOLDER_ID = "folder_id";

	public static final String FIELD_ID = "id";

	public static final String RESULT_ID = "id";

	public static final String RESULT_DATA = "data";

	public static final String RESULT_TIMESTAMP = "timestamp";

	public static final String TREE = "tree";

	public static final String CODE = "code";

	public static final String ERROR = "error";

	public static final String CATEGORY = "category";

	public static final String ATTACHMENTS_LAST_MODIFIED = "lastModifiedOfNewestAttachmentUTC";

	public static final String MODULE = "module";

	public static final String ATTACHED = "attached";
	
	public static final String UID = "uid";
	
	public static final String ACTION_RESOLVEUID = "resolveuid";

	public static final String ERROR_ON_DUPLICATE_NAME = "errorOnDuplicateName";
	
	public static final String ERROR_ON_DUPLICATE_NAME_DB_FIELD = "errOnDuplName";

    public static final String OFF = "off";

    public static final String LEN = "len";
}
