/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.contenttypes.tasks.impl;

import java.util.BitSet;
import com.openexchange.usm.api.contenttypes.folder.OXFolderContent;
import com.openexchange.usm.api.contenttypes.task.TaskConstants;
import com.openexchange.usm.api.contenttypes.task.TaskContentType;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.ox.json.OXJSONAccess;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.api.session.DataObjectFilter;
import com.openexchange.usm.api.session.Folder;
import com.openexchange.usm.contenttypes.util.AbstractTransferHandler;

/**
 * Transfer Handler for the module "Tasks"
 * @author ldo
 *
 */
public class TaskContentTypeTransferHandlerImpl extends AbstractTransferHandler {

	public TaskContentTypeTransferHandlerImpl(TaskContentType contentType, OXJSONAccess access) {
		super(contentType, access);
	}

	@Override
	protected String getOXAjaxAccessPath() {
		return TaskConstants.TASK_PATH;
	}

    @Override
    public OXFolderContent readFolderContent(Folder folder, int limit, DataObjectFilter filter) throws USMException {
        OXFolderContent result = super.readFolderContent(folder, limit, filter);
        resetRecurrenceTypeBasedFields(result.getObjects());
        return result;
    }

	@Override
	public DataObject[] readFolderContent(Folder folder, BitSet requestedFields) throws USMException {
        DataObject[] result = super.readFolderContent(folder, requestedFields);
		resetRecurrenceTypeBasedFields(result);
		return result;
	}

	@Override
	public DataObject[] readUpdatedFolderContent(Folder folder, BitSet requestedFields, long timestamp)
			throws USMException {
		DataObject[] result = super.readUpdatedFolderContent(folder, requestedFields, timestamp);
		resetRecurrenceTypeBasedFields(result);
		return result;
	}

	@Override
	public void writeUpdatedDataObject(DataObject object, long timestamp) throws USMException {
		super.writeUpdatedDataObject(object, timestamp);
		setAppOrTaskConfirmations(object);
	}
	
}
