/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.usm.contenttypes.groups.impl;

import static com.openexchange.usm.api.datatypes.DataTypes.STRING;
import com.openexchange.usm.api.contenttypes.common.CommonConstants;
import com.openexchange.usm.api.contenttypes.common.ContentTypeField;
import com.openexchange.usm.api.contenttypes.common.DefaultContentTypes;
import com.openexchange.usm.api.contenttypes.groups.GroupsConstants;
import com.openexchange.usm.api.contenttypes.groups.GroupsContentType;
import com.openexchange.usm.api.contenttypes.transferhandlers.ContentTypeTransferHandler;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.contenttypes.util.AbstractContentType;

public class GroupsContentTypeImpl extends AbstractContentType implements GroupsContentType {

    private static final ContentTypeField[] FIELDS = {
        new ContentTypeField(-1800, CommonConstants.FIELD_ID, STRING, false, true, false, false), // ID
        new ContentTypeField(-1801, CommonConstants.FOLDER_ID, STRING, false, false, true, false), // Object ID of the parent folder. Dummy
                                                                                                   // field. Always empty
        new ContentTypeField(-1802, GroupsConstants.DISPLAY_NAME, STRING), // Display Name
        new ContentTypeField(-1803, GroupsConstants.NAME, STRING), // Name with character restrictions
        new ContentTypeField(-1804, GroupsConstants.MEMBERS, STRING, true), // Array of group member id's
    };

    private GroupsContentTypeTransferHandler _transferHandler;

    @Override
    public int getCode() {
        return DefaultContentTypes.GROUPS_CODE;
    }

    @Override
    public ContentTypeField[] getFields() {
        return FIELDS;
    }

    @Override
    public String getID() {
        return DefaultContentTypes.GROUPS_ID;
    }

    @Override
    public Object getObjectGroupOwner(DataObject object) {
        return object.getID();
    }

    @Override
    public ContentTypeTransferHandler getTransferHandler() {
        return _transferHandler;
    }

    public void setTransferHandler(GroupsContentTypeTransferHandler transferHandler) {
        _transferHandler = transferHandler;
    }

    @Override
    public boolean supportsPIMAttachments() {
        return false;
    }

    @Override
    public int hashCode() {
        return 191731;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof GroupsContentType))
            return false;
        return true;
    }

    @Override
    public boolean canBeFolderElementsContentType() {
        return false;
    }
}
