/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.datatypes.tasks.calendar;

import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Defines Confirming participant for the Calendar and Tasks module.
 * 
 * @author ldo
 *
 */
public class ConfirmingParticipant implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	static final String TYPE = "type";
	static final String MAIL = "mail";
	static final String DISPLAY_NAME = "display_name";
	static final String STATUS = "status";
	static final String CONFIRM_MESSAGE = "confirmmessage";

	/** Type of the participant. 1- user; 5- external user */
	private final int _type;
	/** email address of external participant */
	private final String _mail;
	/** display name of external participant  */
	private final String _displayName;
	/** Valid values: 0-3 */
	private final int _status;
	/** Confirm Message of the participant */
	private final String _confirmMessage;

	public ConfirmingParticipant(int type, String mail, String displayName, int status, String confirmMessage) {
		_type = type;
		_mail = mail;
		_displayName = displayName;
		_status = status;
		_confirmMessage = confirmMessage;
	}

	public ConfirmingParticipant() {
		_type = 0;
		_mail = "";
		_displayName = "";
		_status = 0;
		_confirmMessage = "";
	}

	public ConfirmingParticipant(JSONObject jObj) {
		_type = jObj.optInt(TYPE, 0);
		_mail = jObj.optString(MAIL, "");
		_displayName = jObj.optString(DISPLAY_NAME, "");
		_status = jObj.optInt(STATUS, 0);
		_confirmMessage = jObj.optString(CONFIRM_MESSAGE, "");
	}

	public int getType() {
		return _type;
	}

	public String getMail() {
		return _mail;
	}

	public String getDisplayName() {
		return _displayName;
	}

	public int getStatus() {
		return _status;
	}

	public String getConfirmMessage() {
		return _confirmMessage;
	}

	public JSONObject toJSONObject() throws JSONException {
		JSONObject result = new JSONObject();
		result.put(TYPE, _type);
		result.put(MAIL, _mail);
		result.put(DISPLAY_NAME, _displayName);
		result.put(STATUS, _status);
		result.put(CONFIRM_MESSAGE, _confirmMessage);
		return result;
	}

	@Override
	public String toString() {
		return '{' + TYPE + ':' + String.valueOf(_type) + ';' + MAIL + ':' + _mail + ';' + DISPLAY_NAME + ':'
				+ _displayName + ';' + STATUS + ':' + String.valueOf(_status) + ';' + CONFIRM_MESSAGE + ':'
				+ _confirmMessage + '}';
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + _type;
		result = prime * result + _mail.hashCode();
		result = prime * result + _displayName.hashCode();
		result = prime * result + _status;
		result = prime * result + _confirmMessage.hashCode();
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ConfirmingParticipant other = (ConfirmingParticipant) obj;
		if (_type != other.getType())
			return false;
		if (!_mail.equals(other.getMail()))
			return false;
		if (!_displayName.equals(other.getDisplayName()))
			return false;
		if (_status != other.getStatus())
			return false;
		if (!_confirmMessage.equals(other.getConfirmMessage()))
			return false;
		return true;
	}
}
