/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.SCRUtil;
import org.eclipse.equinox.internal.ds.model.ComponentReference;
import org.eclipse.equinox.internal.ds.model.ServiceComponentProp;
import org.eclipse.equinox.internal.util.io.Externalizable;
import org.eclipse.equinox.internal.util.io.ExternalizableDictionary;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;

public class ServiceComponent
implements Externalizable {
    public Vector componentProps = null;
    public String name;
    public String factory;
    String implementation;
    Properties properties;
    public Vector serviceInterfaces;
    public String[] provides;
    public boolean serviceFactory = false;
    public Vector references;
    public boolean autoenable = true;
    public boolean immediate = false;
    private boolean activateCached = false;
    private boolean deactivateCached = false;
    private Method activate;
    private Method deactivate;
    public boolean enabled;
    public Bundle bundle;
    public BundleContext bc;
    private static final Class[] ACTIVATE_METHODS_PARAMETERS;
    static /* synthetic */ Class class$0;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.component.ComponentContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        ACTIVATE_METHODS_PARAMETERS = classArray;
    }

    private final Method getMethod(Object instance, String methodName) throws Exception {
        if (Activator.DEBUG) {
            Activator.log.debug(0, 10034, methodName, null, false);
        }
        Method method = null;
        Class<?> clazz = instance != null ? instance.getClass() : null;
        while (method == null && clazz != null) {
            try {
                method = clazz.getDeclaredMethod(methodName, ACTIVATE_METHODS_PARAMETERS);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            clazz = clazz.getSuperclass();
        }
        if (method != null) {
            int modifiers = method.getModifiers();
            if (Modifier.isProtected(modifiers)) {
                SCRUtil.setAccessible(method);
            } else if (!Modifier.isPublic(modifiers)) {
                Activator.log.warning("[SCR] Method '" + methodName + "' is not public or protected and cannot be executed! The method is located in the implementation class of component: " + this, null);
                method = null;
            }
        }
        return method;
    }

    void activate(Object instance, ComponentContext context) throws ComponentException {
        block6: {
            try {
                if (!this.activateCached) {
                    this.activateCached = true;
                    this.activate = this.getMethod(instance, "activate");
                }
                if (this.activate == null) break block6;
                Object[] params = SCRUtil.getObjectArray();
                params[0] = context;
                try {
                    this.activate.invoke(instance, params);
                }
                finally {
                    SCRUtil.release(params);
                }
            }
            catch (Throwable t) {
                Activator.log.error("[SCR] Cannot activate instance " + instance + " of component " + this, null);
                throw new ComponentException("[SCR] Exception while activating instance " + instance + " of component " + this.name, t);
            }
        }
    }

    void deactivate(Object instance, ComponentContext context) {
        block6: {
            try {
                if (!this.deactivateCached) {
                    this.deactivateCached = true;
                    this.deactivate = this.getMethod(instance, "deactivate");
                }
                if (this.deactivate == null) break block6;
                Object[] params = SCRUtil.getObjectArray();
                params[0] = context;
                try {
                    this.deactivate.invoke(instance, params);
                }
                finally {
                    SCRUtil.release(params);
                }
            }
            catch (Throwable t) {
                Activator.log.error("[SCR] Error while attempting to deactivate instance of component " + this, t);
            }
        }
    }

    void validate(int line) {
        if (this.name == null) {
            throw new IllegalArgumentException("The component definition misses 'name' attribute, line " + line);
        }
        if (this.implementation == null) {
            throw new IllegalArgumentException("The component '" + this.name + "' misses 'implementation' attribute, line " + line);
        }
        if (this.factory != null && this.serviceFactory) {
            throw new IllegalArgumentException("The component '" + this.name + "' invalid specifies both ComponentFactory and ServiceFactory");
        }
        if (this.immediate) {
            if (this.serviceFactory) {
                throw new IllegalArgumentException("The component '" + this.name + "' is invalid specified both as immediate and ServiceFactory");
            }
            if (this.factory != null) {
                throw new IllegalArgumentException("The component '" + this.name + "' is invalid specified both as immediate and ComponentFactory");
            }
        } else if (this.serviceInterfaces == null && this.factory == null) {
            throw new IllegalArgumentException("The component '" + this.name + "' is invalid specifying immediate to false and providing no Services");
        }
        if (this.references != null) {
            int i = 0;
            while (i < this.references.size()) {
                ComponentReference r = (ComponentReference)this.references.elementAt(i);
                if (r.name == null || r.interfaceName == null || r.name.equals("") || r.interfaceName.equals("")) {
                    throw new IllegalArgumentException("The component '" + this.name + "' defined at line " + line + " contains illegal reference " + r);
                }
                int j = i + 1;
                while (j < this.references.size()) {
                    ComponentReference ref2 = (ComponentReference)this.references.elementAt(j);
                    if (r.name.equals(ref2.name)) {
                        throw new IllegalArgumentException("The component '" + this.name + "' defined at line " + line + " contains references with duplicate names");
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (this.serviceInterfaces != null && !this.serviceInterfaces.isEmpty()) {
            this.provides = new String[this.serviceInterfaces.size()];
            this.serviceInterfaces.copyInto(this.provides);
        }
        this.enabled = this.autoenable;
    }

    final Object createInstance() throws Exception {
        try {
            return this.bundle.loadClass(this.implementation).newInstance();
        }
        catch (Throwable t) {
            throw new ComponentException("Exception occurred while creating new instance of component " + this, t);
        }
    }

    public final void dispose() {
        this.deactivateCached = false;
        this.activateCached = false;
        this.deactivate = null;
        this.activate = null;
        this.enabled = false;
        this.bundle = null;
        if (this.references != null) {
            int i = 0;
            while (i < this.references.size()) {
                ComponentReference ref = (ComponentReference)this.references.elementAt(i);
                ref.dispose();
                ++i;
            }
            this.references.removeAllElements();
            this.references = null;
        }
        if (this.properties != null) {
            this.properties.clear();
            this.properties = null;
        }
        if (this.serviceInterfaces != null) {
            this.serviceInterfaces.removeAllElements();
            this.serviceInterfaces = null;
        }
    }

    public boolean provides(String interfaceName) {
        return this.serviceInterfaces != null && this.serviceInterfaces.contains(interfaceName);
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Component[");
        buffer.append("\n\tname = ").append(this.name);
        buffer.append("\n\tautoenable = ").append(this.autoenable);
        buffer.append("\n\tfactory = ").append(this.factory);
        buffer.append("\n\timmediate = ").append(this.immediate);
        buffer.append("\n\timplementation = ").append(this.implementation);
        buffer.append("\n\tproperties = ").append(this.properties);
        buffer.append("\n\tserviceFactory = ").append(this.serviceFactory);
        buffer.append("\n\tserviceInterface = ").append(this.serviceInterfaces);
        if (this.references == null) {
            buffer.append("\n\treferences = ").append("null");
        } else {
            buffer.append("\n\treferences = {");
            int i = 0;
            while (i < this.references.size()) {
                buffer.append("\n\t\t").append(this.references.elementAt(i));
                ++i;
            }
            buffer.append("\n\t}");
        }
        buffer.append("\n\tlocated in bundle = ").append(this.bundle);
        buffer.append("\n]");
        return buffer.toString();
    }

    public synchronized void writeObject(OutputStream s) throws Exception {
        try {
            DataOutputStream out = s instanceof DataOutputStream ? (DataOutputStream)s : new DataOutputStream(s);
            out.writeUTF(this.name);
            out.writeUTF(this.implementation);
            out.writeBoolean(this.serviceFactory);
            out.writeBoolean(this.autoenable);
            out.writeBoolean(this.immediate);
            boolean flag = this.factory != null;
            out.writeBoolean(flag);
            if (flag) {
                out.writeUTF(this.factory);
            }
            int count = this.serviceInterfaces == null ? 0 : this.serviceInterfaces.size();
            out.writeInt(count);
            int i = 0;
            while (i < count) {
                out.writeUTF(this.serviceInterfaces.elementAt(i).toString());
                ++i;
            }
            count = this.references == null ? 0 : this.references.size();
            out.writeInt(count);
            i = 0;
            while (i < count) {
                ComponentReference ref = (ComponentReference)this.references.elementAt(i);
                ref.writeObject(out);
                ++i;
            }
            flag = this.properties != null && !this.properties.isEmpty();
            out.writeBoolean(flag);
            if (flag) {
                ExternalizableDictionary dictionary = new ExternalizableDictionary();
                dictionary.copyFrom(this.properties);
                dictionary.writeObject(out);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void readObject(InputStream s) throws Exception {
        try {
            int i;
            int count;
            DataInputStream in = s instanceof DataInputStream ? (DataInputStream)s : new DataInputStream(s);
            this.name = in.readUTF();
            this.implementation = in.readUTF();
            this.serviceFactory = in.readBoolean();
            this.autoenable = in.readBoolean();
            this.immediate = in.readBoolean();
            boolean flag = in.readBoolean();
            if (flag) {
                this.factory = in.readUTF();
            }
            if ((count = in.readInt()) > 0) {
                this.serviceInterfaces = new Vector(count);
                this.provides = new String[count];
                i = 0;
                while (i < count) {
                    String entry = in.readUTF();
                    this.serviceInterfaces.addElement(entry);
                    this.provides[i] = entry;
                    ++i;
                }
            }
            if ((count = in.readInt()) > 0) {
                this.references = new Vector(count);
                i = 0;
                while (i < count) {
                    ComponentReference ref = new ComponentReference(this);
                    ref.readObject(in);
                    ++i;
                }
            }
            if (flag = in.readBoolean()) {
                ExternalizableDictionary dictionary = new ExternalizableDictionary();
                dictionary.readObject(in);
                Properties props = new Properties();
                Enumeration keys = dictionary.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    props.put(key, dictionary.get(key));
                }
                this.properties = props;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ServiceComponentProp getComponentPropByPID(String pid) {
        int i = 0;
        while (i < this.componentProps.size()) {
            ServiceComponentProp scp = (ServiceComponentProp)this.componentProps.elementAt(i);
            if (scp.getProperties() != null && pid.equals(scp.getProperties().get("service.pid"))) {
                return scp;
            }
            ++i;
        }
        return null;
    }

    public void addServiceComponentProp(ServiceComponentProp scp) {
        if (this.componentProps == null) {
            this.componentProps = new Vector(2);
        }
        if (!this.componentProps.contains(scp)) {
            this.componentProps.addElement(scp);
        }
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }
}

