/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.CircularityException;
import org.eclipse.equinox.internal.ds.ConfigurationManager;
import org.eclipse.equinox.internal.ds.InstanceProcess;
import org.eclipse.equinox.internal.ds.Reference;
import org.eclipse.equinox.internal.ds.SCRManager;
import org.eclipse.equinox.internal.ds.WorkPerformer;
import org.eclipse.equinox.internal.ds.model.ComponentReference;
import org.eclipse.equinox.internal.ds.model.ServiceComponent;
import org.eclipse.equinox.internal.ds.model.ServiceComponentProp;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.component.ComponentException;

public final class Resolver
implements WorkPerformer {
    static final String[] WORK_TITLES = new String[]{"BUILD ", "DYNAMICBIND "};
    public static final int BUILD = 1;
    public static final int DYNAMICBIND = 2;
    private Vector scpEnabled;
    public Vector satisfiedSCPs;
    private InstanceProcess instanceProcess;
    private Object syncLock = new Object();
    public SCRManager mgr;

    Resolver(SCRManager mgr) {
        this.scpEnabled = new Vector();
        this.satisfiedSCPs = new Vector();
        this.instanceProcess = new InstanceProcess(this);
        this.mgr = mgr;
    }

    public Object getSyncLock() {
        return this.syncLock;
    }

    void queueBlocked() {
        this.syncLock = new Object();
        this.instanceProcess = new InstanceProcess(this);
    }

    void dispose() {
        Activator.log.info("Resolver.dispose()");
        if (this.instanceProcess != null) {
            this.instanceProcess.dispose();
            this.instanceProcess = null;
        }
        this.scpEnabled.removeAllElements();
        this.satisfiedSCPs.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enableComponents(Vector serviceComponents) {
        long start = 0L;
        if (Activator.DEBUG) {
            Activator.log.debug(0, 10062, serviceComponents != null ? serviceComponents.toString() : "null", null, false);
        }
        if (Activator.PERF) {
            start = System.currentTimeMillis();
        }
        Object object = this.syncLock;
        synchronized (object) {
            Configuration[] configs = null;
            if (serviceComponents != null) {
                int i = 0;
                while (i < serviceComponents.size()) {
                    ServiceComponent current = (ServiceComponent)serviceComponents.elementAt(i);
                    if (!current.enabled) {
                        if (Activator.DEBUG) {
                            Activator.log.debug(0, 10019, current.name, null, false);
                        }
                    } else {
                        try {
                            String filter = "(|(service.pid=" + current.name + ")(" + "service.factoryPid" + '=' + current.name + "))";
                            configs = ConfigurationManager.listConfigurations(filter);
                        }
                        catch (Exception e) {
                            Activator.log.error("[SCR] Cannot list configurations for component " + current.name, (Throwable)e);
                        }
                        if (configs == null || configs.length == 0) {
                            this.map(current, (Dictionary)null);
                        } else {
                            Configuration config = configs[0];
                            if (config.getFactoryPid() != null) {
                                if (current.factory != null) {
                                    Activator.log.error("[SCR - Resolver] Cannot specify both ComponentFactory and ManagedServiceFactory\nThe name of the ComponentFactory component is " + current.name, null);
                                } else {
                                    Activator.log.info("Resolver.enableComponents(): " + current.name + " as *managed service factory*");
                                    try {
                                        configs = ConfigurationManager.listConfigurations("(service.factoryPid=" + config.getFactoryPid() + ")");
                                    }
                                    catch (Exception e) {
                                        Activator.log.error("[SCR] Cannot list configurations for component " + current.name, (Throwable)e);
                                    }
                                    if (configs != null) {
                                        int index = 0;
                                        while (index < configs.length) {
                                            this.map(current, configs[index]);
                                            ++index;
                                        }
                                    }
                                }
                            } else {
                                Activator.log.info("Resolver.enableComponents(): " + current.name + " as *service*");
                                this.map(current, config);
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        this.buildNewlySatisfied();
        if (Activator.PERF) {
            start = System.currentTimeMillis() - start;
            Activator.log.info(String.valueOf(serviceComponents != null ? "[DS perf] " + serviceComponents.size() : "[DS perf]") + " Components enabled for " + start + " ms");
        }
    }

    protected ServiceComponentProp map(ServiceComponent component, Configuration config) {
        Dictionary configProps = null;
        if (config != null) {
            try {
                configProps = config.getProperties();
            }
            catch (IllegalStateException illegalStateException) {}
        }
        ServiceComponentProp scp = this.map(component, configProps);
        if (config != null) {
            String pid = config.getPid();
            String fpid = config.getFactoryPid();
            if (pid != null) {
                scp.properties.put("service.pid", pid);
            }
            if (fpid != null) {
                scp.properties.put("service.factoryPid", fpid);
            }
        }
        return scp;
    }

    public ServiceComponentProp map(ServiceComponent component, Dictionary configProperties) {
        ServiceComponentProp scp = null;
        try {
            if (Activator.DEBUG) {
                Activator.log.debug(0, 10063, component.name, null, false);
            }
            scp = new ServiceComponentProp(component, configProperties, this.mgr);
            Vector referenceDescriptions = component.references;
            if (referenceDescriptions != null && !referenceDescriptions.isEmpty()) {
                Vector<Reference> references = new Vector<Reference>(referenceDescriptions.size());
                int i = 0;
                while (i < referenceDescriptions.size()) {
                    ComponentReference cRef = (ComponentReference)referenceDescriptions.elementAt(i);
                    Reference ref = new Reference(cRef, scp, scp.getProperties());
                    references.addElement(ref);
                    ++i;
                }
                scp.references = references;
            }
            component.addServiceComponentProp(scp);
            this.scpEnabled.addElement(scp);
        }
        catch (Throwable t) {
            Activator.log.error("[SCR] Unexpected exception while creating configuration for component " + component, t);
        }
        return scp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getEligible(ServiceEvent event) {
        if (this.scpEnabled.isEmpty()) {
            return;
        }
        if (Activator.DEBUG) {
            Activator.log.debug(0, 10020, event.toString(), null, false);
            String eventType = "";
            if (event.getType() == 4) {
                eventType = "UNREGISTERING";
            } else if (event.getType() == 1) {
                eventType = "REGISTERED";
            } else if (event.getType() == 2) {
                eventType = "MODIFIED";
            }
            Activator.log.debug(0, 10050, eventType, null, false);
        }
        Cloneable target = null;
        Vector resolvedComponents = null;
        switch (event.getType()) {
            case 1: {
                Vector componentsWithStaticRefs;
                Object object = this.syncLock;
                synchronized (object) {
                    componentsWithStaticRefs = this.selectStaticBind(this.satisfiedSCPs, event.getServiceReference());
                    if (componentsWithStaticRefs != null) {
                        this.removeAll(this.satisfiedSCPs, componentsWithStaticRefs);
                    }
                }
                if (componentsWithStaticRefs != null) {
                    this.instanceProcess.disposeInstances(componentsWithStaticRefs);
                }
                object = this.syncLock;
                synchronized (object) {
                    resolvedComponents = this.resolveEligible();
                    target = this.selectDynamicBind(resolvedComponents, event.getServiceReference());
                    this.removeAll(resolvedComponents, this.satisfiedSCPs);
                    if (!resolvedComponents.isEmpty()) {
                        this.addAll(this.satisfiedSCPs, resolvedComponents);
                    }
                }
                if (target != null) {
                    this.instanceProcess.dynamicBind((Vector)target);
                }
                if (resolvedComponents.isEmpty()) break;
                this.instanceProcess.buildComponents(resolvedComponents, false);
                break;
            }
            case 4: {
                Vector componentsToDispose;
                Vector newlyUnsatisfiedSCPs;
                Object object = this.syncLock;
                synchronized (object) {
                    newlyUnsatisfiedSCPs = (Vector)this.satisfiedSCPs.clone();
                    this.removeAll(newlyUnsatisfiedSCPs, this.resolveEligible());
                    if (!newlyUnsatisfiedSCPs.isEmpty()) {
                        this.removeAll(this.satisfiedSCPs, newlyUnsatisfiedSCPs);
                    }
                }
                if (!newlyUnsatisfiedSCPs.isEmpty()) {
                    this.instanceProcess.disposeInstances(newlyUnsatisfiedSCPs);
                }
                Vector newlySatisfiedSCPs = null;
                Object object2 = this.syncLock;
                synchronized (object2) {
                    componentsToDispose = this.selectStaticUnBind(this.satisfiedSCPs, event.getServiceReference());
                    if (componentsToDispose != null) {
                        this.removeAll(this.satisfiedSCPs, componentsToDispose);
                    }
                }
                if (componentsToDispose != null) {
                    this.instanceProcess.disposeInstances(componentsToDispose);
                }
                object2 = this.syncLock;
                synchronized (object2) {
                    target = this.selectDynamicUnBind(this.satisfiedSCPs, event.getServiceReference());
                    if (componentsToDispose != null) {
                        newlySatisfiedSCPs = this.resolveEligible();
                        this.removeAll(newlySatisfiedSCPs, this.satisfiedSCPs);
                        if (!newlySatisfiedSCPs.isEmpty()) {
                            this.addAll(this.satisfiedSCPs, newlySatisfiedSCPs);
                        }
                    }
                }
                this.instanceProcess.dynamicUnBind((Hashtable)target);
                if (newlySatisfiedSCPs != null && !newlySatisfiedSCPs.isEmpty()) {
                    this.instanceProcess.buildComponents(newlySatisfiedSCPs, false);
                }
                return;
            }
            case 2: {
                Vector newlySatisfiedSCPs;
                Vector componentsToDispose;
                Vector newlyUnsatisfiedSCPs;
                Object object = this.syncLock;
                synchronized (object) {
                    newlyUnsatisfiedSCPs = (Vector)this.satisfiedSCPs.clone();
                    this.removeAll(newlyUnsatisfiedSCPs, this.resolveEligible());
                    if (!newlyUnsatisfiedSCPs.isEmpty()) {
                        this.removeAll(this.satisfiedSCPs, newlyUnsatisfiedSCPs);
                    }
                }
                if (!newlyUnsatisfiedSCPs.isEmpty()) {
                    this.instanceProcess.disposeInstances(newlyUnsatisfiedSCPs);
                }
                object = this.syncLock;
                synchronized (object) {
                    componentsToDispose = this.selectStaticUnBind(this.satisfiedSCPs, event.getServiceReference());
                    if (componentsToDispose != null) {
                        this.removeAll(this.satisfiedSCPs, componentsToDispose);
                    }
                }
                if (componentsToDispose != null) {
                    this.instanceProcess.disposeInstances(componentsToDispose);
                }
                object = this.syncLock;
                synchronized (object) {
                    target = this.selectDynamicUnBind(this.satisfiedSCPs, event.getServiceReference());
                }
                if (target != null) {
                    this.instanceProcess.dynamicUnBind((Hashtable)target);
                }
                object = this.syncLock;
                synchronized (object) {
                    target = this.selectDynamicBind(this.satisfiedSCPs, event.getServiceReference());
                    newlySatisfiedSCPs = this.resolveEligible();
                    this.removeAll(newlySatisfiedSCPs, this.satisfiedSCPs);
                    if (!newlySatisfiedSCPs.isEmpty()) {
                        this.addAll(this.satisfiedSCPs, newlySatisfiedSCPs);
                    }
                }
                if (target != null) {
                    this.instanceProcess.dynamicBind((Vector)target);
                }
                if (newlySatisfiedSCPs.isEmpty()) break;
                this.instanceProcess.buildComponents(newlySatisfiedSCPs, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildNewlySatisfied() {
        Vector resolvedComponents;
        Object object = this.syncLock;
        synchronized (object) {
            this.findDependencyCycles();
            resolvedComponents = this.resolveEligible();
            this.removeAll(resolvedComponents, this.satisfiedSCPs);
            if (!resolvedComponents.isEmpty()) {
                this.addAll(this.satisfiedSCPs, resolvedComponents);
            }
        }
        if (!resolvedComponents.isEmpty()) {
            this.instanceProcess.buildComponents(resolvedComponents, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void componentDisposed(ServiceComponentProp scp) {
        Object object = this.syncLock;
        synchronized (object) {
            int ind = this.satisfiedSCPs.indexOf(scp);
            if (ind >= 0) {
                this.satisfiedSCPs.removeElementAt(ind);
            }
        }
    }

    private Vector resolveEligible() {
        try {
            Vector enabledSCPs = (Vector)this.scpEnabled.clone();
            int k = enabledSCPs.size() - 1;
            while (k >= 0) {
                ServiceComponentProp scp = (ServiceComponentProp)enabledSCPs.elementAt(k);
                Vector refs = scp.references;
                int i = 0;
                while (refs != null && i < refs.size()) {
                    Reference reference = (Reference)refs.elementAt(i);
                    if (reference != null) {
                        boolean resolved;
                        boolean bl = resolved = !reference.isRequiredFor(scp.serviceComponent) || reference.hasProviders();
                        if (!resolved) {
                            if (Activator.DEBUG) {
                                Activator.log.debug("Resolver.resolveEligible(): reference '" + reference.reference.name + "' of component '" + scp.name + "' is not resolved", null);
                            }
                            enabledSCPs.removeElementAt(k);
                            break;
                        }
                        if (scp.getState() == 0) {
                            scp.setState(2);
                        }
                    }
                    ++i;
                }
                if (scp.serviceComponent.provides != null && System.getSecurityManager() != null) {
                    String[] provides = scp.serviceComponent.provides;
                    boolean hasPermission = true;
                    int i2 = 0;
                    while (i2 < provides.length) {
                        block17: {
                            try {
                                if (!scp.bc.getBundle().hasPermission((Object)new ServicePermission(provides[i2], "register"))) {
                                    hasPermission = false;
                                }
                                break block17;
                            }
                            catch (IllegalStateException illegalStateException) {
                                hasPermission = false;
                            }
                            catch (Throwable throwable) {
                                hasPermission = false;
                            }
                            break;
                        }
                        ++i2;
                    }
                    if (!hasPermission) {
                        if (Activator.DEBUG) {
                            Activator.log.debug("Resolver.resolveEligible(): Cannot satisfy component '" + scp.name + "' because its bundle does not have permissions to register service with interface " + provides[i2], null);
                        }
                        this.scpEnabled.removeElementAt(k);
                        enabledSCPs.removeElementAt(k);
                    }
                }
                --k;
            }
            if (Activator.DEBUG) {
                Activator.log.debug(0, 10021, enabledSCPs.toString(), null, false);
            }
            return enabledSCPs;
        }
        catch (Throwable e) {
            Activator.log.error("[SCR] Unexpected exception occurred!", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disableComponents(Vector componentDescriptions) {
        Vector newlyUnsatisfiedSCPs;
        long start = 0L;
        if (Activator.PERF) {
            start = System.currentTimeMillis();
        }
        Vector<ServiceComponentProp> removeList = null;
        if (componentDescriptions != null) {
            int i = 0;
            while (i < componentDescriptions.size()) {
                Vector scpList;
                ServiceComponent component = (ServiceComponent)componentDescriptions.elementAt(i);
                component.enabled = false;
                if (Activator.DEBUG) {
                    Activator.log.debug(0, 10022, component.name, null, false);
                }
                if ((scpList = component.componentProps) != null) {
                    int iter = 0;
                    while (iter < scpList.size()) {
                        ServiceComponentProp scp = (ServiceComponentProp)scpList.elementAt(iter);
                        if (removeList == null) {
                            removeList = new Vector<ServiceComponentProp>();
                        }
                        removeList.addElement(scp);
                        ++iter;
                    }
                }
                if (removeList != null) {
                    this.disposeComponentConfigs(removeList);
                    removeList.removeAllElements();
                }
                if (component.componentProps != null) {
                    component.componentProps.removeAllElements();
                }
                ++i;
            }
        }
        Object object = this.syncLock;
        synchronized (object) {
            newlyUnsatisfiedSCPs = (Vector)this.satisfiedSCPs.clone();
            this.removeAll(newlyUnsatisfiedSCPs, this.resolveEligible());
            if (!newlyUnsatisfiedSCPs.isEmpty()) {
                this.removeAll(this.satisfiedSCPs, newlyUnsatisfiedSCPs);
            }
        }
        if (!newlyUnsatisfiedSCPs.isEmpty()) {
            this.instanceProcess.disposeInstances(newlyUnsatisfiedSCPs);
        }
        if (Activator.PERF) {
            start = System.currentTimeMillis() - start;
            Activator.log.info("[DS perf] " + componentDescriptions.size() + " Components disabled for " + start + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeComponentConfigs(Vector scps) {
        Object object = this.syncLock;
        synchronized (object) {
            this.removeAll(this.satisfiedSCPs, scps);
            this.removeAll(this.scpEnabled, scps);
        }
        this.instanceProcess.disposeInstances(scps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performWork(int workAction, Object workObject) {
        try {
            if (Activator.DEBUG) {
                String work = WORK_TITLES[workAction - 1];
                Activator.log.debug(0, 10023, String.valueOf(work) + workObject, null, false);
            }
            switch (workAction) {
                case 1: {
                    if (workObject == null) break;
                    Vector queue = (Vector)workObject;
                    Object object = this.syncLock;
                    synchronized (object) {
                        int i = queue.size() - 1;
                        while (i >= 0) {
                            if (!this.satisfiedSCPs.contains(queue.elementAt(i))) {
                                queue.removeElementAt(i);
                            }
                            --i;
                        }
                        if (queue.isEmpty()) {
                            return;
                        }
                    }
                    this.instanceProcess.buildComponents(queue, false);
                    Vector toDispose = null;
                    Object i = this.syncLock;
                    synchronized (i) {
                        int i2 = queue.size() - 1;
                        while (i2 >= 0) {
                            if (!this.satisfiedSCPs.contains(queue.elementAt(i2))) {
                                if (toDispose == null) {
                                    toDispose = new Vector(2);
                                }
                                toDispose.addElement(queue.elementAt(i2));
                            }
                            --i2;
                        }
                        if (toDispose == null) {
                            return;
                        }
                    }
                    this.instanceProcess.disposeInstances(toDispose);
                    break;
                }
                case 2: {
                    if (workObject == null) break;
                    Vector toBind = (Vector)workObject;
                    Object object = this.syncLock;
                    synchronized (object) {
                        int i = toBind.size() - 1;
                        while (i >= 0) {
                            Reference ref = (Reference)toBind.elementAt(i);
                            if (!this.satisfiedSCPs.contains(ref.scp)) {
                                toBind.removeElementAt(i);
                            }
                            --i;
                        }
                        if (toBind.isEmpty()) {
                            return;
                        }
                    }
                    this.instanceProcess.dynamicBind(toBind);
                }
            }
        }
        catch (Throwable e) {
            Activator.log.error("[SCR] Unexpected exception occurred!", e);
        }
    }

    private Vector selectDynamicBind(Vector scps, ServiceReference serviceReference) {
        try {
            Vector<Reference> toBind = null;
            int i = 0;
            int size = scps.size();
            while (i < size) {
                ServiceComponentProp scp = (ServiceComponentProp)scps.elementAt(i);
                Vector references = scp.references;
                if (references != null) {
                    int j = 0;
                    while (j < references.size()) {
                        Reference reference = (Reference)references.elementAt(j);
                        if (reference.bindNewReference(serviceReference, true)) {
                            if (toBind == null) {
                                toBind = new Vector<Reference>(2);
                            }
                            toBind.addElement(reference);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (toBind != null && Activator.DEBUG) {
                Activator.log.debug(0, 10025, toBind.toString(), null, false);
            }
            return toBind;
        }
        catch (Throwable t) {
            Activator.log.error("[SCR] Unexpected exception occurred!", t);
            return null;
        }
    }

    private Vector selectStaticBind(Vector scps, ServiceReference serviceReference) {
        try {
            Vector<ServiceComponentProp> toBind = null;
            int i = 0;
            int size = scps.size();
            while (i < size) {
                Vector references;
                ServiceComponentProp scp = (ServiceComponentProp)scps.elementAt(i);
                if (!scp.isComponentFactory() && (references = scp.references) != null) {
                    int j = 0;
                    while (j < references.size()) {
                        Reference reference = (Reference)references.elementAt(j);
                        if (reference.bindNewReference(serviceReference, false)) {
                            if (toBind == null) {
                                toBind = new Vector<ServiceComponentProp>(2);
                            }
                            toBind.addElement(scp);
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (toBind != null && Activator.DEBUG) {
                Activator.log.debug(0, 10061, toBind.toString(), null, false);
            }
            return toBind;
        }
        catch (Throwable t) {
            Activator.log.error("[SCR] Unexpected exception occurred!", t);
            return null;
        }
    }

    private Vector selectStaticUnBind(Vector scpsToCheck, ServiceReference serviceReference) {
        try {
            Vector<ServiceComponentProp> toUnbind = null;
            int i = 0;
            int size = scpsToCheck.size();
            while (i < size) {
                ServiceComponentProp scp = (ServiceComponentProp)scpsToCheck.elementAt(i);
                Vector references = scp.references;
                if (references != null) {
                    int j = 0;
                    while (j < references.size()) {
                        Reference reference = (Reference)references.elementAt(j);
                        if (reference.staticUnbindReference(serviceReference)) {
                            if (toUnbind == null) {
                                toUnbind = new Vector<ServiceComponentProp>(2);
                            }
                            toUnbind.addElement(scp);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (toUnbind != null && Activator.DEBUG) {
                Activator.log.debug(0, 10060, toUnbind.toString(), null, false);
            }
            return toUnbind;
        }
        catch (Throwable t) {
            Activator.log.error("[SCR] Unexpected exception occurred!", t);
            return null;
        }
    }

    private Hashtable selectDynamicUnBind(Vector scps, ServiceReference serviceReference) {
        try {
            if (Activator.DEBUG) {
                Activator.log.debug(0, 10026, null, null, false);
            }
            Hashtable unbindTable = null;
            Hashtable<ServiceComponentProp, ServiceReference> unbindSubTable = null;
            int i = 0;
            while (i < scps.size()) {
                ServiceComponentProp scp = (ServiceComponentProp)scps.elementAt(i);
                Vector references = scp.references;
                if (references != null) {
                    int j = 0;
                    while (j < references.size()) {
                        Reference reference = (Reference)references.elementAt(j);
                        if (reference.dynamicUnbindReference(serviceReference)) {
                            if (Activator.DEBUG) {
                                Activator.log.debug(0, 10027, scp.toString(), null, false);
                            }
                            if (unbindSubTable == null) {
                                unbindSubTable = new Hashtable<ServiceComponentProp, ServiceReference>(11);
                            }
                            unbindSubTable.put(scp, serviceReference);
                            if (unbindTable == null) {
                                unbindTable = new Hashtable(11);
                            }
                            unbindTable.put(reference, unbindSubTable);
                        } else if (Activator.DEBUG) {
                            Activator.log.debug("Resolver.selectDynamicUnBind(): not unbinding " + scp + " service ref=" + serviceReference, null);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (unbindTable != null && Activator.DEBUG) {
                Activator.log.debug(0, 10028, unbindTable.toString(), null, false);
            }
            return unbindTable;
        }
        catch (Throwable t) {
            Activator.log.error("[SCR] Unexpected exception occurred!", t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceComponentProp mapNewFactoryComponent(ServiceComponent component, Dictionary configProperties) {
        Object object = this.syncLock;
        synchronized (object) {
            ServiceComponentProp newSCP = this.map(component, configProperties);
            newSCP.setComponentFactory(false);
            this.findDependencyCycles();
            Vector newlySatisfiedSCPs = this.resolveEligible();
            this.removeAll(newlySatisfiedSCPs, this.satisfiedSCPs);
            if (!newlySatisfiedSCPs.contains(newSCP)) {
                this.scpEnabled.removeElement(newSCP);
                throw new ComponentException("Cannot resolve instance of " + newSCP + " with properties " + configProperties);
            }
            this.satisfiedSCPs.addElement(newSCP);
            return newSCP;
        }
    }

    private void findDependencyCycles() {
        Vector emptyVector = new Vector();
        try {
            Hashtable dependencies = new Hashtable();
            int i = this.scpEnabled.size() - 1;
            while (i >= 0) {
                ServiceComponentProp enabledSCP = (ServiceComponentProp)this.scpEnabled.elementAt(i);
                if (enabledSCP.references != null) {
                    Vector<ReferenceSCPWrapper> dependencyVector = new Vector<ReferenceSCPWrapper>(1);
                    int j = 0;
                    while (j < enabledSCP.references.size()) {
                        Reference reference = (Reference)enabledSCP.references.elementAt(j);
                        ServiceComponentProp[] providerSCPs = reference.selectProviders(this.scpEnabled);
                        if (providerSCPs != null) {
                            int k = 0;
                            while (k < providerSCPs.length) {
                                dependencyVector.addElement(new ReferenceSCPWrapper(reference, providerSCPs[k]));
                                ++k;
                            }
                        }
                        ++j;
                    }
                    if (!dependencyVector.isEmpty()) {
                        dependencies.put(enabledSCP, dependencyVector);
                    } else {
                        dependencies.put(enabledSCP, emptyVector);
                    }
                }
                --i;
            }
            Hashtable visited = new Hashtable(11);
            Enumeration keys = dependencies.keys();
            while (keys.hasMoreElements()) {
                ServiceComponentProp scp = (ServiceComponentProp)keys.nextElement();
                if (visited.containsKey(scp)) continue;
                Vector currentStack = new Vector(2);
                this.checkDependencies(scp, visited, dependencies, currentStack);
            }
        }
        catch (CircularityException e) {
            Activator.log.error("[SCR] Circularity Exception found for component: " + e.getCausingComponent().serviceComponent, (Throwable)e);
            this.scpEnabled.removeElement(e.getCausingComponent());
            this.findDependencyCycles();
        }
    }

    private void checkDependencies(ServiceComponentProp scp, Hashtable visited, Hashtable dependencies, Vector currentStack) throws CircularityException {
        if (visited.containsKey(scp)) {
            return;
        }
        Vector refSCPs = (Vector)dependencies.get(scp);
        if (refSCPs != null) {
            int i = 0;
            while (i < refSCPs.size()) {
                ReferenceSCPWrapper refSCP = (ReferenceSCPWrapper)refSCPs.elementAt(i);
                if (currentStack.contains(refSCP)) {
                    this.processDependencyCycle(refSCP, currentStack);
                } else {
                    currentStack.addElement(refSCP);
                    this.checkDependencies(refSCP.producer, visited, dependencies, currentStack);
                    currentStack.removeElement(refSCP);
                }
                ++i;
            }
        }
        visited.put(scp, "");
    }

    private void processDependencyCycle(ReferenceSCPWrapper refSCP, Vector currentStack) throws CircularityException {
        ReferenceSCPWrapper optionalRefSCP = null;
        int i = currentStack.indexOf(refSCP);
        while (i < currentStack.size()) {
            ReferenceSCPWrapper cycleRefSCP = (ReferenceSCPWrapper)currentStack.elementAt(i);
            if (!cycleRefSCP.ref.isRequired()) {
                optionalRefSCP = cycleRefSCP;
                break;
            }
            ++i;
        }
        if (optionalRefSCP == null) {
            throw new CircularityException(refSCP.ref.scp);
        }
        if (optionalRefSCP.ref.policy == 0) {
            Activator.log.error("[SCR] Static optional reference detected in a component cycle and it will be removed.The referece is " + optionalRefSCP.ref.reference, null);
            optionalRefSCP.ref.scp.references.removeElement(optionalRefSCP.ref);
        }
        optionalRefSCP.ref.scp.setDelayActivateSCPName(optionalRefSCP.producer.serviceComponent.name);
    }

    private void removeAll(Vector src, Vector elementsToRemove) {
        int i = src.size() - 1;
        while (i >= 0) {
            if (elementsToRemove.contains(src.elementAt(i))) {
                src.removeElementAt(i);
            }
            --i;
        }
    }

    private void addAll(Vector src, Vector elementsToAdd) {
        int i = 0;
        while (i < elementsToAdd.size()) {
            if (!src.contains(elementsToAdd.elementAt(i))) {
                src.addElement(elementsToAdd.elementAt(i));
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromSatisfiedList(ServiceComponentProp scp) {
        Object object = this.syncLock;
        synchronized (object) {
            this.satisfiedSCPs.remove(scp);
        }
    }

    private class ReferenceSCPWrapper {
        public Reference ref;
        public ServiceComponentProp producer;

        protected ReferenceSCPWrapper(Reference ref, ServiceComponentProp producer) {
            this.ref = ref;
            this.producer = producer;
        }

        public String toString() {
            return "Reference : " + this.ref + " ::: SCP : " + this.producer;
        }
    }
}

